<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use App\Models\Payment;
use App\Models\Setting;
use App\Models\User;
use App\Models\Leader;
use App\Models\Notice;
use App\Models\Job;
use App\Models\Withdraw;
use App\Models\Gmail;
use App\Models\JobSubmit;
use App\Models\FBAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    
    
public function processLeaderSalaries()
{
    $now = Carbon::now();

    $leaders = Leader::all();

    foreach ($leaders as $leader) {
        if ($leader->last_salary) {
            $lastSalaryDate = Carbon::parse($leader->last_salary);
        } else {
            // If last_salary is missing, assume they're due now
            $lastSalaryDate = $now->copy()->subDays(31);
        }

        $diffDays = $lastSalaryDate->diffInDays($now);

        if ($diffDays >= 30) {
            DB::transaction(function () use ($leader, $now) {
                $user = User::find($leader->user_id);
                if ($user) {
                    // Add salary to user's balance
                    $user->balance += $leader->salary;
                    $user->save();

                    // Update last_salary
                    $leader->last_salary = $now;
                    $leader->save();
                }
            });
        }
    }

    echo "Leader salaries processed at " . now();
}

    
    public function AdminLeadersDelete($id)
{
    // Find the leader by ID
    $leader = Leader::find($id);

    // If leader not found, return a not found response
    if (!$leader) {
        return redirect()->back()->with('error', 'Leader not found.');
    }

    // Delete the leader
    $leader->delete();

    // Return a success message
    return redirect()->back()->with('success', 'Leader deleted successfully!');
}
    public function AdminLeadersAddOrUpdate(Request $request)
{
    // Validate the incoming request
    $request->validate([
        'user_id' => 'required|exists:users,id',
        'rank' => 'required|string|max:255',
        'reffer' => 'required',
        'salary' => 'required|numeric',
    ]);

    // Check if leader already exists (update case)
    $leader = Leader::where('user_id', $request->user_id)->first();

    if ($leader) {
        // Update existing leader
        $leader->reffer = $request->reffer;
        $leader->rank = $request->rank;
        $leader->salary = $request->salary;
        $leader->save();
        return redirect()->back()->with('success', 'Leader updated successfully!');
    } else {
        // Add a new leader
        $leader = new Leader();
        $leader->user_id = $request->user_id;
        $leader->rank = $request->rank;
        $leader->reffer = $request->reffer;
        $leader->salary = $request->salary;
        $leader->last_salary = Carbon::today(); // Set the last salary to today
        $leader->save();
        return redirect()->back()->with('success', 'Leader added successfully!');
    }
}
    
        public function AdminTasks() {
            $jobSubmits = JobSubmit::latest()->paginate(100);
        return view('dashboard.tasks', compact('jobSubmits'));
    }
        public function AdminLeaders() {
             $leaders = Leader::with('user')->latest()->paginate(100);
             $users = User::latest()->get();
            return view('dashboard.leaders', compact('leaders', 'users'));
    }
    
    public function DeactivateAllAccounts()
{
    User::query()->update(['user_active' => 0]);
        $settings = Setting::where('key', 'new_users_status')->first();
        $settings->value = 0;
        $settings->save();

    return back()->with('success', 'All users have been deactivated successfully.');
}

    public function ActivateAllAccounts()
    {
        User::query()->update(['user_active' => 1]);
       $settings = Setting::where('key', 'new_users_status')->first();
        $settings->value = 1;
        $settings->save();
        return back()->with('success', 'All users have been activated successfully.');
    }

public function AdminTasksUpdateStatus(Request $request)
{
    $request->validate([
        'job_submit_id' => 'required',
        'status' => 'required|in:Approved,Rejected',
    ]);

    $jobSubmit = JobSubmit::findOrFail($request->job_submit_id);

    if ($jobSubmit->status !== 'Pending') {
        return back()->with('error', 'This submission has already been reviewed. Current status: ' . $jobSubmit->status);
    }

    $jobSubmit->status = $request->status;
    $jobSubmit->save();

    $message = "Job status updated to {$request->status}.";

    if ($request->status === 'Approved') {
        $user = User::find($jobSubmit->user_id);

        if ($user) {
            $oldTodayJob = $user->today_job;
            $oldBalance = $user->balance;

            $user->today_job += 1;
            $user->balance += $jobSubmit->amount;
            $user->save();

            $message .= " User updated: Today Jobs from {$oldTodayJob} to {$user->today_job}, Balance from {$oldBalance} to {$user->balance}.";
        } else {
            $message .= " User not found for update.";
        }
    }

    return back()->with('success', $message);
}

public function updateFBAccountStatus(Request $request)
{
    try {
        // Use find() instead of findOrFail() to handle non-existent records more gracefully
        $fbAccount = FBAccount::find($request->fb_account_id);
    
        if (!$fbAccount) {
            return redirect()->back()->with('error', 'Facebook account not found!');
        }
    
        // If the status is 'Approved', update the user's balance
        if ($request->status == 'Approved') {
            // Find the user associated with this Facebook account
            $user = User::where('id', $fbAccount->user_id)->first();
    
            if ($user) {
                $user->balance += $fbAccount->price;
                $user->save();
            } else {
                return redirect()->back()->with('error', 'User not found!');
            }
        }
    
        $fbAccount->status = $request->status;
        $fbAccount->save();
    
        return redirect()->back()->with('success', 'Status updated successfully!');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Something went wrong. Please try again. ' . $e->getMessage());
    }
}
public function updateGmailAccountStatus(Request $request)
{
    try {
        // Use find() instead of findOrFail() to handle non-existent records more gracefully
        $fbAccount = Gmail::find($request->fb_account_id);
    
        if (!$fbAccount) {
            return redirect()->back()->with('error', 'Facebook account not found!');
        }
    
        // If the status is 'Approved', update the user's balance
        if ($request->status == 'Approved') {
            // Find the user associated with this Facebook account
            $user = User::where('id', $fbAccount->user_id)->first();
    
            if ($user) {
                $user->balance += $fbAccount->price;
                $user->save();
            } else {
                return redirect()->back()->with('error', 'User not found!');
            }
        }
    
        $fbAccount->status = $request->status;
        $fbAccount->save();
    
        return redirect()->back()->with('success', 'Status updated successfully!');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Something went wrong. Please try again. ' . $e->getMessage());
    }
}





    public function getLogin(){
        return view('auth.login');
    }
    
    
    public function AdminFacebook (){
        return view('dashboard.fb');
    }
    
    public function AdminGmail (){
        return view('dashboard.gmail');
    }
    
    public function taskSettings() {
        $data = Job::take(4)->get(); // Get the first 3 tasks
        return view('dashboard.task_setting', compact('data'));
    }

    public function taskSettingsPost(Request $request) {
    $request->validate([
        'id' => 'required|exists:jobs,id',
        'job_title' => 'required|string',
        'job_description' => 'nullable|string',
        'amount' => 'required|numeric',
        'task_url' => 'required|url',
    ]);

    Job::where('id', $request->id)->update([
        'job_title' => $request->job_title,
        'job_description' => $request->job_description,
        'amount' => $request->amount,
        'task_url' => $request->task_url,
    ]);

    return redirect()->route('taskSettings')->with('success', 'Task updated successfully!');
}

    public function ActiveUsers(){
        $data = User::where('user_active', '=', '1')->get();
        return view('dashboard.usersdata', compact('data'));
    }
    public function ActiveUser(Request $request){
        $data = User::where('id', '=', $request->id)->update(['deactive' => "no"]);
        return redirect()->route('ActiveUsers')->with('success', "Active success");
    }
    public function DectiveUser(Request $request){
        $data = User::where('id', '=', $request->id)->update(['deactive' => "yes"]);
        return redirect()->route('ActiveUsers')->with('success', "Deactive success");
    }
    public function WithdrawPaid(Request $request){
        $data = Withdraw::where('id', '=', $request->id)->update(['status' => "Success"]);
        return redirect()->route('AdminWithdraws')->with('success', "Paid success");
    }
    public function WithdrawFailed(Request $request){
        $data = Withdraw::where('id', '=', $request->id)->update(['status' => "Failed"]);
        $data = Withdraw::where('id', '=', $request->id)->get()->first();
        User::where('id', "=", $data->user_id)->increment('balance', $data->amount);
        
        return redirect()->route('AdminWithdraws')->with('success', "Failed success");
    }
    public function InActiveUsers(){
        $data = User::where('user_active', '=', '0')->get();
        return view('dashboard.usersdata', compact('data'));
    }

    public function AdminPayments(){
        $data = Payment::get();
        return view('dashboard.paymentsdata', compact('data'));
    }
    public function AdminWithdraws(){
        $data = Withdraw::get();
        return view('dashboard.withdrawssdata', compact('data'));
    }
    public function changepwd(){
        return view('dashboard.change_password');
    }
    
    public function NoticeAdmin(){
        $data = Notice::get();
        return view('dashboard.notice', compact('data'));
    }
    public function NoticeAdminDelete(Request $request){
        $data = Notice::where('id', '=', $request->id)->delete();
        return redirect()->route('NoticeAdmin')->with('success', "Delete success");
    }
    public function submitNotice(Request $request){
        $request->validate([
            'notice_title' => 'required',
            'notice_content' => 'required',
        ]);
        $data = Notice::create(["notice_title" => $request->notice_title, "notice_body" => $request->notice_content, ]);
        return redirect()->route('NoticeAdmin')->with('success', "Add success");
    }

    public function changepwdPost(Request $request){
        $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|confirmed',
        ]);

        if(!Hash::check($request->old_password, Auth::guard('admin')->user()->password)){
            return back()->with("error", "Old Password Doesn't match!");
        }

        Admin::whereId(Auth::guard('admin')->user()->id)->update([
            'password' => Hash::make($request->new_password)
        ]);

        return back()->with("success", "Password changed successfully!");

    }

    public function systemSettings(){
        $settings = Setting::all()->pluck('value', 'key')->toArray();
        return view('dashboard.system_settings', ['settings' => $settings]);
    }

    public function systemSettingsPost(Request $request){
        $newSettings = $request->input('settings');

        foreach ($newSettings as $key => $value) {
            Setting::updateOrCreate(['key' => $key], ['value' => $value]);
        }

        return redirect()->route('systemSettings')->with('success', 'Settings updated successfully');
    }

    public function AdminDash(){
        $data = [
            'title' => 'Dashboard',
            'active_users' => User::where('user_active', '=', '1')->count(),
            'inactive_users' => User::where('user_active', '=', '0')->count(),
            'payments' => Payment::where('status', '=', 'Success')->sum('amount'),
            'withdraws' => Withdraw::where('status', '=', 'Success')->sum('amount')
        ];

        return view('dashboard.dashboard', $data);
    }

    public function postLogin(Request $request){
        $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        $remember = $request->input('remember', false);

        $validated = Auth::guard('admin')->attempt([
            'email' => $request->email,
            'password' => $request->password
        ], $remember);

        if($validated){
            return redirect()->route('AdminDash');
        }else{
            return redirect()->back()->with('error', 'These credentials do not match.');
        }
    }
}
