<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Job;
use App\Models\JobSubmit;
use App\Models\Notice;
use App\Models\Payment;
use App\Models\User;
use App\Models\Withdraw;
use App\Models\FBAccount;
use App\Models\Setting;
use App\Models\Gmail;
use App\Models\Leader;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class dashController extends Controller
{
    
    public function fb_store(Request $request) {
        try {
            // Validate the request
            $request->validate([
                'fb_uid' => 'required|string',
                'fb_email' => 'required|email',
                'fb_pass' => 'required|string',
                'fb_2f_key' => 'nullable|string',
            ]);
    
            // Create the Facebook account record
            FBAccount::create([
                'fb_uid' => $request->fb_uid,
                'fb_email' => $request->fb_email,
                'fb_pass' => $request->fb_pass, // Encrypt password for security
                'fb_2f_key' => $request->fb_2f_key,
                'user_id' => auth()->id(), // Link to authenticated user
                'status' => 'Pending', // Default status
                'price' => Setting::where('key', 'fb_id_price')->first()->value ?? 0, 
            ]);
    
            // Return success message
            return redirect()->back()->with('success', 'Facebook ID sell requested successfully!');
            
        } catch (\Illuminate\Validation\ValidationException $e) {
            // Catch validation errors and return detailed feedback
            return redirect()->back()->withErrors($e->validator->errors())->withInput();
            
        } catch (\Exception $e) {
            // Log the actual error for debugging
            \Log::error('Facebook Account Store Error: ' . $e->getMessage());
    
            // Return a user-friendly error message
            return redirect()->back()->with('error', 'Something went wrong! Please try again.');
        }
    }

    public function raferlink()
{
    try {
        $user = Auth::user();

        // Step 1: First level referrals (Active refers only)
        $step1Count = User::where('ref_by', $user->ref_code) 
                          ->where('user_active', 1) 
                          ->count();
        $step1Progress = min(100, ($step1Count / 12) * 100);  

        // Step 2: Second level referrals
        $firstLevelUsers = User::where('ref_by', $user->ref_code)->pluck('ref_code');
        $step2Count = User::whereIn('ref_by', $firstLevelUsers)
                          ->where('user_active', 1)  
                          ->count();
        $step2Progress = min(100, ($step2Count / 45) * 100); 
        // Check if month can be claimed
        $canClaim = ($step1Count >= 12) && ($step2Count >= 45); 

        return view('user.raferlink', compact('step1Count', 'step1Progress', 'step2Count', 'step2Progress', 'canClaim'));
    } catch (QueryException $e) {
        return redirect()->route('dashboard')->with('error', 'Error fetching raferlink data');
    }
}

    
    public function gmail_store(Request $request) {
    try {
        // Validate the request
        $request->validate([
            'gmail' => 'required|string',
            're_gmail' => 'required|email',
            'password' => 'required|string',
            'backup_code' => 'nullable|string',
        ]);

        // Create the Gmail account record
        Gmail::create([
            'gmail' => $request->gmail,
            're_gmail' => $request->re_gmail,
            'password' => $request->password, // Encrypt password for security
            'backup' => $request->backup_code ?? 'N/A',
            'user_id' => auth()->id(), // Link to authenticated user
            'status' => 'Pending', // Default status
            'price' => Setting::where('key', 'gmail_price')->first()->value ?? 0, 
        ]);

        // Redirect with success message
        return redirect()->back()->with('success', 'Gmail sell requested successfully!');
        
    } catch (\Illuminate\Validation\ValidationException $e) {
        // Catch validation errors and return errors via URL
        $errorMessage = urlencode(implode(', ', $e->validator->errors()->all()));
        return redirect()->back()->withInput()->with('error', $errorMessage);
        
    } catch (\Exception $e) {
        // Log the actual error for debugging
        \Log::error('Gmail Account Store Error: ' . $e->getMessage());

        // Return a user-friendly error via URL
        $errorMessage = urlencode('Something went wrong! Please try again.');
        return redirect()->back()->withInput()->with('error', $errorMessage);
    }
}

    public function month()
{
    try {
        $user = Auth::user();

        // Step 1: First level referrals (Active refers only)
        $step1Count = User::where('ref_by', $user->ref_code) 
                          ->where('user_active', 1) 
                          ->count();
        $step1Progress = min(100, ($step1Count / 12) * 100);  

        // Step 2: Second level referrals
        $firstLevelUsers = User::where('ref_by', $user->ref_code)->pluck('ref_code');
        $step2Count = User::whereIn('ref_by', $firstLevelUsers)
                          ->where('user_active', 1)  
                          ->count();
        $step2Progress = min(100, ($step2Count / 45) * 100); 
        // Check if month can be claimed
        $canClaim = ($step1Count >= 12) && ($step2Count >= 45); 

        return view('user.month', compact('step1Count', 'step1Progress', 'step2Count', 'step2Progress', 'canClaim'));
    } catch (QueryException $e) {
        return redirect()->route('dashboard')->with('error', 'Error fetching month data');
    }
}

public function salary()
{
    try {
        $user = Auth::user();

        // Step 1: First level referrals (Active refers only)
        $step1Count = User::where('ref_by', $user->ref_code) 
                          ->where('user_active', 1) 
                          ->count();
        $step1Progress = min(00, ($step1Count / 12) * 00);  

        // Step 2: Second level referrals
        $firstLevelUsers = User::where('ref_by', $user->ref_code)->pluck('ref_code');
        $step2Count = User::whereIn('ref_by', $firstLevelUsers)
                          ->where('user_active', 1)  
                          ->count();
        $step2Progress = min(00, ($step2Count / 45) * 00); 
        // Check if salary can be claimed
        $canClaim = ($step1Count >= 12) && ($step2Count >= 45); 

        return view('user.salary', compact('step1Count', 'step1Progress', 'step2Count', 'step2Progress', 'canClaim'));
    } catch (QueryException $e) {
        return redirect()->route('dashboard')->with('error', 'Error fetching salary data');
    }
}

    public function dashboard(Request $request){
        if(auth()->user()->deactive == "yes"){
            Auth::logout();
            $request->session()->invalidate();
            return redirect()->route('login')->with("error", "Account Banned");
        }
        $data = Notice::get();
        $totalWithdrawalAmount = Withdraw::where('user_id', auth()->user()->id)->sum('amount');
        return view('user.dashboard' , compact('data'), ['totalWithdrawalAmount' => $totalWithdrawalAmount]);
    }
    
    public function fb_sell(Request $request){
        if(auth()->user()->deactive == "yes"){
            Auth::logout();
            $request->session()->invalidate();
            return redirect()->route('login')->with("error", "Account Banned");
        }
        $data = Notice::get();
        $totalWithdrawalAmount = Withdraw::where('user_id', auth()->user()->id)->sum('amount');
        return view('user.fb_sell' , compact('data'), ['totalWithdrawalAmount' => $totalWithdrawalAmount]);
    }
   public function leaderbaord(Request $request)
{
    if (auth()->user()->deactive == "yes") {
        Auth::logout();
        $request->session()->invalidate();
        return redirect()->route('login')->with("error", "Account Banned");
    }

    $data = Notice::get();
    $leaders = Leader::orderBy('rank')->get();


    return view('user.leaderbaord', compact('data', 'leaders'));
}

    public function gmail_sell(Request $request){
        if(auth()->user()->deactive == "yes"){
            Auth::logout();
            $request->session()->invalidate();
            return redirect()->route('login')->with("error", "Account Banned");
        }
        if(auth()->user()->user_active == "0"){
            return redirect()->route('dashboard')->with("error", "First Activate your account");
        }
        $data = Notice::get();
        $totalWithdrawalAmount = Withdraw::where('user_id', auth()->user()->id)->sum('amount');
        return view('user.gmail_sell' , compact('data'), ['totalWithdrawalAmount' => $totalWithdrawalAmount]);
    }
    public function fb_history(Request $request){
        if(auth()->user()->deactive == "yes"){
            Auth::logout();
            $request->session()->invalidate();
            return redirect()->route('login')->with("error", "Account Banned");
        }
        $data = Notice::get();
        $totalWithdrawalAmount = Withdraw::where('user_id', auth()->user()->id)->sum('amount');
        return view('user.fb_history' , compact('data'), ['totalWithdrawalAmount' => $totalWithdrawalAmount]);
    }
    public function gmail_history(Request $request){
        if(auth()->user()->deactive == "yes"){
            Auth::logout();
            $request->session()->invalidate();
            return redirect()->route('login')->with("error", "Account Banned");
        }
        $data = Notice::get();
        $totalWithdrawalAmount = Withdraw::where('user_id', auth()->user()->id)->sum('amount');
        return view('user.gmail_history' , compact('data'), ['totalWithdrawalAmount' => $totalWithdrawalAmount]);
    }

    public function logout(Request $request){

        Auth::logout();
        $request->session()->invalidate();
        return redirect()->route('login');

    }

    public function payment(){
        $data = Payment::where("user_id", auth()->user()->id)->get();
        return view('user.payment', compact('data'));
    }
    
    public function premium(){
        // $data = Payment::where("user_id", auth()->user()->id)->get();
        return view('user.premium');
    }
    
    public function PremiumBuy(Request $request){
        if(auth()->user()->user_active == '0'){
            return redirect()->back()->with(['error' => 'Active your account first.']);
        }
        
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://pay.babypay.site/request/payment/create',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => http_build_query(array('cus_name' => auth()->user()->fname ." ". auth()->user()->lname,'cus_email' => auth()->user()->email,'amount' => $request->amount,'success_url' => route('package_payment_status', $request->task),'cancel_url' => route('account_payment_status', '0'))),
            CURLOPT_HTTPHEADER => array(
                'app-key: DfgtyZTbtXvtW',
                'secret-key: 55040671',
                'host-name: earnjobsell.com'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }
    
    public function package_payment_status(Request $request){
        $payment_status = auth()->user()->id;
        $task = $request->task;
        if($payment_status){

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://pay.babypay.site/request/payment/verify',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => false,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => http_build_query(array('transaction_id' => request('transactionId'))),
                CURLOPT_HTTPHEADER => array(
                    'app-key: DfgtyZTbtXvtW',
                'secret-key: 55040671',
                'host-name: earnjobsell.com'
                ),
            ));

            $response = json_decode(curl_exec($curl));

            curl_close($curl);
            $status = $response->status;

            if($status){
                $transaction_id = $response->transaction_id;
                $amount = $response->amount;
                $user_id = $payment_status;
                $p_type = $request->p_type;
                
                $today = date("Y-m-d");
                $futureDate = date("Y-m-d", strtotime($today . " +30 days"));
                
                
                $active_user = User::where('id', $user_id)->update(['job_limit' => $task, 'running_pack' => $amount, 'pack_expire' => $futureDate]);
                $payment_add = Payment::create([
                    'user_id' => $user_id,
                    'method' => $p_type,
                    'number' => $transaction_id,
                    'trxid' => $transaction_id,
                    'amount' => $amount,
                    'status' => 'Success',
                ]);

                if($active_user AND $payment_add){
                    
                        // $userId = $user_id;
                        
                        // $user = User::find($userId);
                        // $user->balance = auth()->user()->balance;
                        // $user->save();
                        
                        // $this->handleReferralCommissions($user, $amount, 1);
                        
                        return redirect()->route('dashboard')->with(['success' => 'Package actived']);
                        
                }else{
                    return redirect()->route('dashboard')->with(['error' => 'Payment failed']);
                }
            }else{
                return redirect()->route('dashboard')->with(['error' => 'Payment failed']);
            }
        }else{
            return redirect()->route('dashboard')->with(['error' => 'Payment canceled']);
        }
    }

    
    public function Myjobs(){
        $data = JobSubmit::where("user_id", auth()->user()->id)->get();
        return view('user.my-task-list', compact('data'));
    }

 public function jobs() {
    $today_job = auth()->user()->today_job;
    $job_limit = auth()->user()->job_limit;

    // Calculate remaining jobs
    $take_job = $job_limit - $today_job;

    // Show maximum of 3 jobs, even if more are available
    $data = Job::skip($today_job)->take(4)->get();

    return view('user.job', compact('data'));
}

    public function first_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $firstLevelUsers = User::whereIn('ref_code', $firstLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $firstLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }


    public function second_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $secondLevelUsers = User::whereIn('ref_by', $firstLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $secondLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }


    public function third_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $secondLevelUsers = User::whereIn('ref_by', $firstLevelReferralCodes)->get();
            $secondLevelReferralCodes = $secondLevelUsers->pluck('ref_code')->toArray();

            $thirdLevelUsers = User::whereIn('ref_by', $secondLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $thirdLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }

    public function fourth_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $secondLevelUsers = User::whereIn('ref_by', $firstLevelReferralCodes)->get();
            $secondLevelReferralCodes = $secondLevelUsers->pluck('ref_code')->toArray();

            $thirdLevelUsers = User::whereIn('ref_by', $secondLevelReferralCodes)->get();
            $thirdLevelReferralCodes = $thirdLevelUsers->pluck('ref_code')->toArray();

            $fourthLevelUsers = User::whereIn('ref_by', $thirdLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $fourthLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }


    public function helpline(){
        return view('user.helpline');
    }

    public function notice(){
        $data = Notice::get();
        return view('user.notice', compact('data'));
    }

    public function myteam(){
        try {
            $userRefCode = auth()->user()->ref_code;

            $firstLevelCount = User::where('ref_by', $userRefCode)->count();

            $secondLevelCount = User::whereIn('ref_by', function ($query) use ($userRefCode) {
                $query->select('ref_code')
                    ->from('users')
                    ->where('ref_by', $userRefCode);
            })->count();

            $thirdLevelCount = User::whereIn('ref_by', function ($query) use ($userRefCode) {
                $query->select('ref_code')
                    ->from('users')
                    ->whereIn('ref_by', function ($subQuery) use ($userRefCode) {
                        $subQuery->select('ref_code')
                            ->from('users')
                            ->where('ref_by', $userRefCode);
                    });
            })->count();

            $fourthLevelCount = User::whereIn('ref_by', function ($query) use ($userRefCode) {
                $query->select('ref_code')
                    ->from('users')
                    ->whereIn('ref_by', function ($subQuery) use ($userRefCode) {
                        $subQuery->select('ref_code')
                            ->from('users')
                            ->whereIn('ref_by', function ($subSubQuery) use ($userRefCode) {
                                $subSubQuery->select('ref_code')
                                    ->from('users')
                                    ->where('ref_by', $userRefCode);
                            });
                    });
            })->count();
            $totalCount = $firstLevelCount + $secondLevelCount + $thirdLevelCount + $fourthLevelCount;
            return view('user.myteam', compact('firstLevelCount', 'secondLevelCount', 'thirdLevelCount', 'fourthLevelCount', 'totalCount'));
        } catch (QueryException $e) {
            // Handle the exception here, you can log it or return a custom error view
            return view('user.myteam', [
                'firstLevelCount' => 0,
                'secondLevelCount' => 0,
                'thirdLevelCount' => 0,
                'fourthLevelCount' => 0,
            ]);
        }
    }

    public function task_submit(Request $request){
        $todayJob = auth()->user()->today_job;
        $userActive = auth()->user()->user_active;
        $job_limit = auth()->user()->job_limit;
        $running_pack = auth()->user()->running_pack;
        
        if($job_limit <= $todayJob){
            
            return redirect()->back()->with(['error' => "Job Limit Over"]);
            
        }
        // AND $running_pack == '0'
        if($userActive == '0' ){
            
            return redirect()->back()->with(['error' => "Package not active"]);
            
        }
            
        $request->validate([
            'job_submit_image' => 'image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        // if ($request->hasFile('job_submit_image')) {

        //     $image = $request->file('job_submit_image');
        //     $imageName = time() . '.' . $image->getClientOriginalExtension();
        //     $path = public_path('uploads/job_submit/');
        //     $image->move($path, $imageName);

        // }
        
        $job_amount = Job::find($request->job_id)->amount;
        
        $query = JobSubmit::create([
            'user_id' => auth()->user()->id,
            'amount' => $job_amount,
            'job_id' => $request->job_id,
            // 'job_image' => $imageName
            'job_image' => ""
        ]);

        $query2 = User::where('id', auth()->user()->id)->update(['today_job' => (auth()->user()->today_job + 1), 'balance' => (auth()->user()->balance + $job_amount)]);

        if($query AND $query2){
            
            return redirect()->back()->with(['success' => "Job Submit Successfully"]);
            
        }else{
            return redirect()->back()->with(['error' => "Job Submit Error"]);
        }
            
        return redirect()->back()->with(['error' => "System Error"]);

    }

    public function profile_update(Request $request){
        $request->validate([
            "first_name" => "required",
            "last_name" => "required",
            "email" => "required|email",
            "phone" => "required",
            'profile_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $password = $request->password;
        $imageName = "";

        if($request->has('password')){
            $password = auth()->user()->password;
        }

        if ($request->hasFile('profile_image')) {

            $image = $request->file('profile_image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $path = public_path('uploads/profile_images/');
            $image->move($path, $imageName);

        }

        $query = User::where("id", auth()->user()->id)->update([
            'fname' => $request->first_name,
            'lname' => $request->last_name,
            'email' => $request->email,
            'password' => $password,
            'profile_image' => $imageName
        ]);

        if($query){
            return redirect()->back()->with(['success' => "Profile Updated successfully"]);
        }else{
            return redirect()->back()->with(['error' => "Profile Update error"]);
        }

    }

    public function profile(){
        $data = auth()->user();
        return view('user.profile', compact('data'));
    }

    public function withdraw(){
        $data = Withdraw::where("user_id", auth()->user()->id)->get();
        return view('user.withdraw', compact('data'));
    }

    public function withdrawCreate(){
        return view('user.withdraw_create');
    }

    public function withdrawCreate_submit(Request $request){
        if(auth()->user()->user_active == '0'){
            return redirect()->back()->with(['error' => 'Active your account first.']);
        }

        $request->validate([
            "withdraw_method" => "required",
            "withdraw_to_number" => "required",
            "req_amount" => "required"
        ]);

        $selectedValue = $request->input('req_amount');
        $valuesArray = explode(':', $selectedValue);

        $amountWithFee = $valuesArray[0]; // Amount with fee
        $totalFee = $valuesArray[1]; // fee
        $mainAmount = $amountWithFee - $totalFee;

        if (auth()->user()->balance < $amountWithFee) {
            return redirect()->back()->with(['error' => 'Insufficient balance.']);
        }

        $updatedBalance = auth()->user()->balance - $amountWithFee;
        $userUpdate = User::where("id", auth()->user()->id)->update(['balance' => $updatedBalance]);
        $createWithraw = Withdraw::create([
            'user_id' => auth()->user()->id,
            'amount' => $mainAmount,
            'charges' => $totalFee,
            'wallet' => $request->withdraw_to_number,
            'method' => $request->withdraw_method,
            'status' => 'Pending',
        ]);

        if($createWithraw AND $userUpdate){
            return redirect()->back()->with(['success' => 'Withdraw request received.']);
        }

        return redirect()->back()->with(['error' => 'Contact support please.']);
    }


    public function account_payment(){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://pay.babypay.site/request/payment/create',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => http_build_query(array('cus_name' => auth()->user()->fname ." ". auth()->user()->lname,'cus_email' => auth()->user()->email,'amount' => app('account_price'),'success_url' => route('account_payment_status', auth()->user()->id),'cancel_url' => route('account_payment_status', '0'))),
            CURLOPT_HTTPHEADER => array(
                'app-key: DfgtyZTbtXvtW',
                'secret-key: 55040671',
                'host-name: earnjobsell.com'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }

    public function account_payment_status(Request $request){
        $payment_status = $request->status;
        if($payment_status){

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://pay.babypay.site/request/payment/verify',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => false,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => http_build_query(array('transaction_id' => request('transactionId'))),
                CURLOPT_HTTPHEADER => array(
                'app-key: DfgtyZTbtXvtW',
                'secret-key: 55040671',
                'host-name: earnjobsell.com'
                ),
            ));

            $response = json_decode(curl_exec($curl));

            curl_close($curl);
            $status = $response->status;

            if($status){
                $transaction_id = $response->transaction_id;
                $amount = $response->amount;
                $user_id = $payment_status;
                $p_type = $request->p_type;

                $active_user = User::where('id', $user_id)->update(['user_active' => '1', 'job_limit' => '4']);
                $payment_add = Payment::create([
                    'user_id' => $user_id,
                    'method' => $p_type,
                    'number' => $transaction_id,
                    'trxid' => $transaction_id,
                    'amount' => $amount,
                    'status' => 'Success',
                ]);

                if($active_user AND $payment_add){
                    
                        // Assume the request contains user_id and amount parameters
                        $userId = $user_id;

                        // Find the user who will receive the money
                        $user = User::find($userId);
                
                        // Update the user's balance
                        $user->balance = auth()->user()->balance;
                        $user->save();
                
                        // Handle referral commissions for up to four levels
                        $this->handleReferralCommissions($user, $amount, 1);
                        
                        return redirect()->route('dashboard')->with(['success' => 'Your account is active now']);
                        
                        
                }else{
                    return redirect()->route('dashboard')->with(['error' => 'Payment failed']);
                }
            }else{
                return redirect()->route('dashboard')->with(['error' => 'Payment failed']);
            }
        }else{
            return redirect()->route('dashboard')->with(['error' => 'Payment canceled']);
        }
    }

    private function handleReferralCommissions($user, $amount, $level){
        if ($level > 4 || !$user->ref_by) {
            // Maximum 4 levels or no referrer
            return;
        }
    
        // Find the referrer
        $referrer = User::where('ref_code', $user->ref_by)->first();
    
        // Check if the referrer exists
        if (!$referrer) {
            // Handle the case where the referrer is not found
            return;
        }
    
        // Define referral commission rates for each level
        // $commissionRates = [0.20, 0.15, 0.10, 0.05];
        $commissionRates = [app('refer_level_1'), app('refer_level_2'), app('refer_level_3'), app('refer_level_4')];
    
        // Calculate the referral commission based on the current level
        $referralCommission = $commissionRates[$level - 1] * $amount;
    
        // Update the referrer's balance
        $referrer->balance += $referralCommission;
        $referrer->save();
    
        // Recursively handle the next level
        $this->handleReferralCommissions($referrer, $amount, $level + 1);
    }
    
    public function cronJob()
    {
        // Zero Task
        $taskReset = User::query()->update(['today_job' => '0']);
        
        $currentDate = date("Y-m-d");
        $expire_user = User::where('pack_expire', '<', $currentDate)->update(['running_pack' => '0', 'pack_expire' => null]);
        
        $users = User::all();
        foreach ($users as $user) {
            if($user->pack_expire == null){
                if($user->user_active == '1'){
                    User::where('id', '=', $user->id)->update(['job_limit' => '4']);
                }else{
                    User::where('id', '=', $user->id)->update(['job_limit' => '0']);
                }
            }else{
                if($user->running_pack == '300'){
                    User::where('id', '=', $user->id)->update(['job_limit' => '2']);
                }elseif($user->running_pack == '500'){
                    User::where('id', '=', $user->id)->update(['job_limit' => '3']);
                }
            }
        }
        
        
    }

}