<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Password;

class indexController extends Controller
{
    public function index(){
        return view('user.index');
    }

    public function catalog(){
        return view('user.catalog');
    }

    public function login(){
        return view('user.login');
    }

    public function register(){
        return view('user.register');
    }

    public function register_submit(Request $request){
        $request->validate([
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required',
            'password' => ['required', Password::min(8)],
            'password_confirmation' => 'required|same:password',
//            'ref_by' => 'required|exists:users'
        ]);

        $existingUser = User::where('phone', $request->phone)->first();

        if ($existingUser) {
            // Handle the case where the phone number already exists
            return redirect()->back()->with(["error" => "Phone number already in use. Please use a different phone number."]);
        }

       $quary = User::create([
        'fname' => $request->first_name,
        'lname' => $request->last_name,
        'email' => $request->email,
        'phone' => $request->phone,
        'password' => Hash::make($request->password),
        'balance' => '0',
        'ref_code' => Str::random(14),
        'user_active' => app('new_users_status'),
        'job_limit' => app('new_users_status') == 1 ? '4' : '0',
        'ref_by' => $request->ref_by
    ]);
        $this->handleReferralCommissions($quary, app('account_price'), 1);
        if($quary){
            return redirect()->route('login')->with(["success" => "Account created. Please login now"]);
        }else{
            return redirect()->back()->with(["error" => "Account creation Failed. Please contact us"]);
        }
    }

private function handleReferralCommissions($user, $amount, $level){
    if ($level > 4 || !$user->ref_by) return;

    $referrer = User::where('ref_code', $user->ref_by)->first();

    if (!$referrer) return;

    $commissionRates = [
        floatval(app('refer_level_1')),
        floatval(app('refer_level_2')),
        floatval(app('refer_level_3')),
        floatval(app('refer_level_4'))
    ];

    $referralCommission = $commissionRates[$level - 1] * $amount;

    $referrer->balance = (float)$referrer->balance + $referralCommission;
    $referrer->save();

    \Log::info("Referral: Level $level | Referrer: {$referrer->phone} | Commission: $referralCommission");

    // Continue to next level
    $this->handleReferralCommissions($referrer, $amount, $level + 1);
}

    
    public function login_submit(Request$request){
        $request->validate([
            'login_phone' => 'required',
            'login_password' => ['required', Password::min(8)]
        ]);

        $remember = $request->input('login_remember', false);

        $validated = auth()->attempt([
            'phone' => $request->login_phone,
            'password' => $request->login_password
        ], $remember);

        if($validated){
            return redirect()->route('dashboard');
        }else{
            return redirect()->back()->with('error', 'These credentials do not match.');
        }
    }
}
