<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Foundation\Auth\User as Authenticatable;
class User extends Authenticatable {

    protected $table = 'users';

    protected $fillable = [
        'fname',
        'lname',
        'phone',
        'email',
        'password',
        'balance',
        'user_active',
        'ref_code',
        'ref_by',
        'today_job',
        'job_limit',
        'profile_image'
    ];
    
    protected $attributes = [
        'today_job' => '0'
    ];


    public function withdraw()
    {
        return $this->hasMany(Withdraw::class);
    }

    public function referrals()
    {
        return $this->hasMany(User::class, 'ref_by', 'id');
    }

    public function referrer()
    {
        return $this->belongsTo(User::class, 'ref_by', 'id');
    }

}
