@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Notice</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('AdminDash')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Notice</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')


            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <!-- /.card-header -->
                        <div class="card-body">
                            <!-- Button trigger modal -->
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                                  Add Notice
                                </button>
                                
                                <!-- Modal -->
                                <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                  <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                      <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel">Add Notice</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                          <span aria-hidden="true">&times;</span>
                                        </button>
                                      </div>
                                      <form action="{{ route('submitNotice') }}" method="post">
                                          @csrf
                                      <div class="modal-body">
                                          <div class="form-group">
                                            <label for="notice_Title">Title</label>
                                            <input type="text" class="form-control" name="notice_title" placeholder="notice title">
                                          </div>
                                          <div class="form-group">
                                            <label for="notice_Content">Content</label>
                                            <textarea class="form-control" name="notice_content" rows="5"></textarea>
                                          </div>
                                      </div>
                                      <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">CLOSE</button>
                                        <button type="submit" class="btn btn-primary" >ADD</button>
                                      </div>
                                      </form>
                                    </div>
                                  </div>
                                </div>
                                <br><br>
                            <table id="callRecordsTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th data-sortable="true">ID</th>
                                    <th data-sortable="true">Date</th>
                                    <th data-sortable="false">Title</th>
                                    <th data-sortable="false">Conent</th>
                                    <th data-sortable="true">Action</th>
                                </tr>
                                </thead>
                                @foreach($data as $item)
                                    <tr class="text-center">
                                        {{--                                        <td colspan="7">Record Not Found!</td>--}}
                                        <td>{{ $item->id }}</td>
                                        <td>{{ \Carbon\Carbon::parse($item->created_at)->format('d.m.Y') }}</td>
                                        <td>{{ $item->notice_title }}</td>
                                        <td>{{ $item->notice_body }}</td>
                                        <td><a href="{{ route('NoticeAdminDelete', $item->id) }}">DELETE</a></td>
                                    </tr>
                                @endforeach
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>


@endsection
