@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Search Domain</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Search Domain</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <h2 class="text-center display-4">Search</h2>
            <div class="row">
                <div class="col-md-8 offset-md-2">
                    <form action="{{route('searchDomain')}}" method="post">
                        <div class="input-group">
                            <input type="search" class="form-control form-control-lg" name="domain_name" value="{{ isset($domain_name)?$domain_name:'' }}" placeholder="Enter the domain name">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-lg btn-default">
                                    <i class="fa fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        @isset($responseData)
            @foreach($responseData as $product)
                @php
                    $status = $product['status'];
                @endphp

                <div class="row mt-3">
                    <div class="col-md-10 offset-md-1">
                        <div class="list-group">
                            <div class="list-group-item">
                                <div class="row">
                                    <div class="col px-4">
                                        <div>
                                            {{--<h3>Hosting Data - {{ $product['id'] }}</h3>--}}
                                            <table class="table table-hover">

                                                <tbody>
                                                <tr>
                                                    <td>Domain Name</td>
                                                    <td>{{ $product['domainname'] }}
                                                        <a href="https://dnsprint.com/whois/{{ $product['domainname'] }}" target="_blank" class="btn btn-info btn-custom-sm" data-toggle="tooltip" data-placement="top" title="Check domain WHOIS">
                                                            <i class="fas fa-question-circle fa-sm"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Registerer</td>
                                                    <td>{{ $product['registrar'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td>Reg Period</td>
                                                    <td>{{ $product['regperiod'] }} Year</td>
                                                </tr>
                                                <tr>
                                                    <td>Reg Date</td>
                                                    <td>{{ $product['regdate'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td>Expiry Date</td>
                                                    <td>{{ $product['expirydate'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td>Next Due Date</td>
                                                    <td>{{ $product['nextduedate'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td>Reg Payment</td>
                                                    <td>{{ $product['firstpaymentamount'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td>Renew Payment</td>
                                                    <td>{{ $product['recurringamount'] }}</td>
                                                </tr>
                                                <tr>
                                                    <td>Status</td>
                                                    <td>
                                                        <button type="button" class="btn btn-{{ $status === 'Active' ? 'success' : ($status === 'Pending' ? 'info' : ($status === 'Pending Transfer' ? 'info' : ($status === 'Cancelled' ? 'secondary' : ($status === 'Grace Period' ? 'danger' : 'warning')))) }} btn-sm">
                                                            {{ $product['status'] }}
                                                        </button>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Menage</td>
                                                    <td>
                                                        <a class="btn btn-primary btn-sm" href="{{ route('DomainNs', $product['id']) }}">
                                                            Nameserver
                                                        </a>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endisset
    </section>

    <style>
        .btn-custom-sm {
            padding: 0.2rem 0.4rem;
            font-size: 0.75rem;
            margin-left: 0.2rem;
        }
    </style>
@endsection
