@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">System Setting</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('AdminDash')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">System Setting</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')

    <div class="col-md-12">
        <div class="card">

            <form action="{{ route('systemSettingsPost') }}" method="post">
                @csrf
                <div class="card-body">
                    @foreach ($settings as $key => $value)
                    <div class="mb-3">
                        <label class="form-label" for="{{ $key }}">{{ ucfirst(str_replace('_', ' ',$key)) }}:</label>
                        <input type="text" class="form-control" name="settings[{{ $key }}]" id="{{ $key }}" value="{{ $value }}">
                    </div>
                    @endforeach
                </div>

                <div class="card-footer">
                    <button class="btn btn-success">Submit</button>
                </div>
            </form>
        </div>
    </div>


@endsection
