@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Task Setting</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('AdminDash')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Task Setting</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')
<div class="col-md-12">
    <div class="card">
        @foreach($data as $task)
            <form action="{{ route('taskSettingsPost') }}" method="post" class="border-bottom p-3">
                @csrf
                <input type="hidden" name="id" value="{{ $task->id }}">

                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Task Title:</label>
                        <input type="text" class="form-control" name="job_title" value="{{ $task->job_title }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Task Amount:</label>
                        <input type="text" class="form-control" name="amount" value="{{ $task->amount }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Task URL:</label>
                        <input type="text" class="form-control" name="task_url" value="{{ $task->task_url }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Task Description:</label>
                        <textarea class="form-control" name="job_description">{{ $task->job_description }}</textarea>
                    </div>
                </div>

                <div class="card-footer text-end">
                    <button class="btn btn-success">Submit Task {{ $loop->iteration }}</button>
                </div>
            </form>
        @endforeach
    </div>
</div>

@endsection
