@extends('layouts.main-layout')

@section('content-header')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Job Submits</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('AdminDash') }}">Dashboard</a></li>
                    <li class="breadcrumb-item active">Job Submits</li>
                </ol>
            </div>
        </div>
    </div>
</div>
@endsection

@section('body')
@php
    use App\Models\JobSubmit;
    use App\Models\User;


@endphp

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Job Submission List</h3>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Job ID</th>
                            <th>Amount</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Submitted At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($jobSubmits as $submit)
                            <tr>
                                <td>{{ $submit->id }}</td>
                                <td>
                                    @php
                                        $user = \App\Models\User::find($submit->user_id);
                                    @endphp
                                    {{ $user ? $user->name : 'N/A' }} (ID: {{ $submit->user_id }})
                                </td>
                                <td>{{ $submit->job_id }}</td>
                                <td>{{ $submit->amount }} BDT</td>
                                <td>
                                    <a href="{{ asset('storage/' . $submit->job_image) }}" target="_blank">
                                        <img src="{{  $submit->job_image }}" width="50">
                                    </a>
                                </td>
                                <td>
                                    @if($submit->status == 'Pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($submit->status == 'Approved')
                                        <span class="badge bg-success">Approved</span>
                                    @elseif($submit->status == 'Rejected')
                                        <span class="badge bg-danger">Rejected</span>
                                    @else
                                        <span class="badge bg-secondary">{{ $submit->status }}</span>
                                    @endif
                                </td>
                                <td>{{ $submit->created_at->format('M d, Y h:i A') }}</td>
                                <td>
                                    @if($submit->status == 'Pending')
                                    <!-- Update Status Modal Trigger -->
                                        <button class="btn btn-sm btn-primary" data-toggle="modal" data-target="#updateJobModal_{{ $submit->id }}">Review</button>
                                    @endif
                                </td>
                            </tr>

                            <!-- Modal -->
                            <div class="modal fade" id="updateJobModal_{{ $submit->id }}" tabindex="-1" role="dialog" aria-labelledby="updateJobModalLabel_{{ $submit->id }}" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form method="POST" action="{{ route('AdminTasksUpdateStatus') }}">
                                        @csrf
                                        <input type="hidden" name="job_submit_id" value="{{ $submit->id }}">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Update Job Status</h5>
                                                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                                            </div>
                                            <div class="modal-body">
                                                <p>Submitted Image:</p>
                                                <img src="{{  $submit->job_image }}" class="img-fluid mb-3">

                                                <div class="form-group">
                                                    <label for="status">Select Status</label>
                                                    <select class="form-control" name="status" required>
                                                        <option value="Approved">Approve</option>
                                                        <option value="Rejected">Reject</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button class="btn btn-success" type="submit">Update</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-center mt-4">
    {{ $jobSubmits->links('pagination::bootstrap-4') }}
</div>

            </div>
        </div>
    </div>
</div>
@endsection
