@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Users</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('AdminDash')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Users</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')


            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="callRecordsTable" class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th data-sortable="true">ID</th>
                                    <th data-sortable="false">Name</th>
                                    <th data-sortable="false">Number</th>
                                    <th data-sortable="false">Email</th>
                                    <th data-sortable="true">Balance</th>
                                    <th data-sortable="true">Status</th>
                                    <th data-sortable="true">Deactive</th>
                                    <th data-sortable="true">Join</th>
                                    <th data-sortable="false">Action</th>
                                </tr>
                                </thead>
                                    @foreach($data as $item)
                                        <tr>
                                            <td>{{ $item->id }}</td>
                                            <td>{{ $item->fname }} {{ $item->lname }}</td>
                                            <td>{{ $item->phone }}</td>
                                            <td>{{ $item->email }}</td>
                                            <td>{{ $item->balance }} BDT</td>
                                            <td>
                                                @if($item->user_active == 0)
                                                    <span style="color: red;">In-Active</span>
                                                @else
                                                    <span style="color: green;">Active</span>
                                                @endif
                                            </td>
                                            <td>{{ $item->deactive }}</td>
                                            <td>{{ $item->created_at->format('M D Y') }}</td>
                                            <td><a href="{{ route('ActiveUser', $item->id) }}">ACTIVE</a> / <a href="{{ route('DectiveUser', $item->id) }}">DEACTIVE</a></td>
                                        </tr>
                                    @endforeach
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>


@endsection
