
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>UNIQUE EARNING Updating...</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: #f8f9fa;
      margin: 0;
      padding: 0;
    }

    /* হেডার */
    .header {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      padding: 15px 20px 60px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: white;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      border-bottom-left-radius: 80px 30px;
      border-bottom-right-radius: 80px 30px;
      position: relative;
      z-index: 1001;
    }
    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .header-left i, .header-right i {
      font-size: 26px;
      cursor: pointer;
    }
    .header-left span {
      font-size: 22px;
      font-weight: bold;
    }
    
    /* সাইডবার */
.sidebar { 
  position: fixed;
  top: 0;
  left: -260px;
  height: 100%;
  width: 260px;
  background: linear-gradient(180deg, #43a047, #2e7d32);
  transition: all 0.3s ease;
  z-index: 9999;
  overflow-y: auto;
  padding-top: 20px;
  box-shadow: 2px 0 8px rgba(0, 0, 0, 0.2);
}

/* সাইডবার লিঙ্ক */
.sidebar a {
  display: flex;
  align-items: center;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  color: white;
  text-decoration: none;
  font-size: 18px;
  transition: background 0.3s ease;
  margin: 0;
  line-height: 1;
}

.sidebar a i {
  margin-right: 10px;
}

.sidebar a:hover {
  background: #16a085;
}

.sidebar a .link-text {
  flex-grow: 1;
  margin-left: 10px;
  text-align: left;
}

.sidebar a .arrow {
  margin-left: auto;
}

/* সাইডবার হেডার */
.sidebar-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 15px; /* হেডারের প্যাডিং কমানো হলো */
  background: linear-gradient(90deg, #4CAF50, #2ecc71);
}

.sidebar-header h2 {
  color: white;
  font-size: 20px;
  margin: 0;
}

/* সাইডবার ক্লোজ বাটন */
.sidebar .close-btn {
  font-size: 30px;
  color: white;
  cursor: pointer;
}

/* সাইডবার লিঙ্কের তালিকা */
.sidebar-links {
  list-style: none;
  padding: 0;
  margin: 0;
}

.sidebar-links li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  border-bottom: 1px solid #fff; /* সাদা দাগ */
}

.sidebar-links li a {
  display: flex;
  align-items: center;
  color: white;
  text-decoration: none;
  font-size: 16px;
  flex-grow: 1;
}

.sidebar-links li a i {
  margin-right: 8px;
  font-size: 18px;
}

/* রেসপন্সিভ */
@media (max-width: 768px) {
  .sidebar {
    width: 230px;
  }
}
.sidebar-user-info {
  padding: 20px 10px;
  border-bottom: 1px solid #ffffff;
  text-align: center;
}

.sidebar-user-info .profile-pic img {
  height: 80px;
  width: 80px;
  object-fit: cover;
  border-radius: 50%;
  border: 2px solid white;
  margin-bottom: 10px;
}

.sidebar-user-info .decorative-line {
  height: 20px;
  margin: 0 auto 10px;
  display: block;
}

.sidebar-user-info .user-name {
  margin: 5px 0;
  font-size: 18px;
  color: #ffffff;
  font-weight: bold;
}

.sidebar-user-info .user-data {
  margin-top: 8px;
  color: #ffffff;
  font-size: 14px;
}

.sidebar-user-info .user-data p {
  margin: 4px 0;
}

.sidebar-user-info .account-status {
  margin-top: 8px;
  padding: 6px 20px;
  background: linear-gradient(135deg, #6a11cb, #2575fc);
  border-radius: 20px;
  display: inline-block;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  font-weight: bold;
}


.user-info {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-top: 20px;
}

.user-info img {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  border: 3px solid #ffffff;
  object-fit: cover; /* ইমেজকে সুন্দরভাবে কাটবে */
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* হালকা ছায়া */
}

.user-info h3 {
  margin: 10px 0 5px;
  font-size: 20px;
  color: #ffffff;
  font-weight: 600;
}

.user-info p {
  font-size: 14px;
  color: #ecf0f1;
  margin: 2px 0;
}
    
    /* ফুটার */
    .footer {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      display: flex;
      justify-content: space-around;
      align-items: center;
      padding: 10px 0;
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      z-index: 999;
      height: 65px;
      box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
    }
    .footer-item {
      color: white;
      text-decoration: none;
      font-size: 13px;
      display: flex;
      flex-direction: column;
      align-items: center;
      flex: 1;
      position: relative;
    }
    .footer-item i {
      font-size: 22px;
      margin-bottom: 3px;
    }
    .footer-item:not(:last-child)::after {
      content: "";
      position: absolute;
      right: 0;
      top: 10px;
      bottom: 10px;
      width: 1px;
      background: rgba(255,255,255,0.5);
    }

    
</style>
</head>

<body>



<!-- সাইডবারের কোড -->
<div class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <h2>মেনু</h2>
    <button class="close-sidebar" onclick="toggleSidebar()">×</button>
  </div>
 
 
<div class="sidebar-user-info text-center">
    <div class="profile-pic">
        <img src="{{ asset('uploads/profile_images/' . Auth::user()->profile_image) }}" alt="User">
    </div>
    
    
    <h5 class="user-name">{{auth()->user()->fname}} {{auth()->user()->lname}}</h5>
    
    <div class="user-data">
        <p class="m-0">Refer ID: {{ auth()->user()->ref_code }}</p>
        <p class="m-0">Joined: {{ auth()->user()->created_at->format('M D Y') }}</p>
        
        <div class="account-status">
            একাউন্ট সেটিংস : 
            <span style="color: #ff4d4d">
                🎉
            </span>
        </div>
    </div>
</div>
    
  <ul class="sidebar-links">
  <li>
    <a href="/dashboard">
      <i class="fas fa-home"></i> হোম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/profile">
      <i class="fas fa-user"></i> প্রোফাইল
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/notice">
      <i class="fas fa-coins""></i>আমার ইনকাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="{{ app('telegram_url') }}">
      <i class="fab fa-telegram"></i> টেলিগ্রাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/withdraw/create">
      <i class="fas fa-money-bill-wave"></i> উত্তোলন 
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/helpline">
      <i class="fas fa-headset"></i> সাপোর্ট
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/raferlink">
      <i class="fas fa-user-cog"></i> রেফার করি
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/logout">
      <i class="fas fa-sign-out-alt"></i> লগ আউট
      <span class="arrow">&gt;</span>
    </a>
  </li>
</ul>
<br>
<br>
</div>

<!-- হেডার -->
<div class="header">
  <div class="header-left">
    <i class="fas fa-bars" id="menuToggle"></i>
    <span>LONG LIFE</span>
  </div>
  <div class="header-right">
    <i class="fas fa-bell"></i>
  </div>
</div>

<!-- রেফার লিংক এবং একাউন্ট নাম্বার বক্স -->
<div style="max-width: 500px; margin: 20px auto;">

  <div style="background-color: #d4edda; border: 1px solid #28a745; border-radius: 10px; padding: 15px; margin-bottom: 15px;">
    <label style="font-weight: bold; color: #155724;">আপনার রেফার লিংক:</label>
    <div style="display: flex; margin-top: 8px;">
      <input type="text" id="refLink" value="{{ route('register') }}?by={{ auth()->user()->ref_code }}" readonly 
             style="flex: 1; padding: 8px; border: none; border-radius: 5px; background: #eafaf1; color: #155724;">
      <button onclick="copyText('refLink')" 
              style="margin-left: 10px; background: #28a745; color: white; border: none; padding: 8px 12px; border-radius: 5px; cursor: pointer;">
        কপি
      </button>
    </div>
  </div>

  <div style="background-color: #d4edda; border: 1px solid #28a745; border-radius: 10px; padding: 15px;">
    <label style="font-weight: bold; color: #155724;">আপনার একাউন্ট নাম্বার:</label>
    <div style="display: flex; margin-top: 8px;">
      <input type="text" id="accountNumber" value="{{ auth()->user()->ref_code }}" readonly 
             style="flex: 1; padding: 8px; border: none; border-radius: 5px; background: #eafaf1; color: #155724;">
      <button onclick="copyText('accountNumber')" 
              style="margin-left: 10px; background: #28a745; color: white; border: none; padding: 8px 12px; border-radius: 5px; cursor: pointer;">
        কপি
      </button>
    </div>
  </div>
 <br>
 <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali&display=swap" rel="stylesheet">
  <style>
    /* Scoped style to avoid conflict */
    .referral-container * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    .referral-container {
      font-family: 'Noto Sans Bengali', sans-serif;
      background: #f5f7fa;
      color: #333;
      line-height: 1.6;
      width: 90%;
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 20px;
    }

    .referral-banner {
      width: 100%;
      max-width: 1200px;
      position: relative;
      padding-top: 25%; /* 4:1 aspect ratio */
      border-radius: 12px;
      overflow: hidden;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
      margin-bottom: 30px;
    }

    .referral-banner img {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      object-fit: cover;
      display: block;
    }

    .referral-content {
      width: 100%;
      max-width: 900px;
      background: white;
      border-radius: 12px;
      padding: 30px 40px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      text-align: center;
    }

    .referral-content h1 {
      font-size: 2.2rem;
      color: #007bff;
      margin-bottom: 20px;
      font-weight: 700;
    }

    .referral-content p {
      font-size: 1.1rem;
      margin-bottom: 20px;
      color: #555;
    }

    .referral-income-list {
      text-align: left;
      list-style: none;
      padding-left: 0;
    }

    .referral-income-list li {
      margin-bottom: 15px;
      font-size: 1.05rem;
      padding-left: 25px;
      position: relative;
      color: #222;
    }

    .referral-income-list li::before {
      content: "✔";
      color: #28a745;
      font-weight: bold;
      position: absolute;
      left: 0;
      top: 0;
      font-size: 1.2rem;
      line-height: 1;
    }

    .referral-button {
      display: inline-block;
      margin-top: 25px;
      padding: 12px 24px;
      background: #007bff;
      color: #fff;
      text-decoration: none;
      border-radius: 6px;
      font-weight: bold;
      transition: background 0.3s;
    }

    .referral-button:hover {
      background: #0056b3;
    }

    @media (max-width: 768px) {
      .referral-content {
        padding: 25px 20px;
      }

      .referral-content h1 {
        font-size: 1.8rem;
      }

      .referral-income-list li {
        font-size: 1rem;
        padding-left: 20px;
      }

      .referral-income-list li::before {
        font-size: 1rem;
      }

      .referral-button {
        font-size: 0.95rem;
        padding: 10px 20px;
      }
    }
  </style>
</head>
<body>
  <div class="referral-container">
    <div class="referral-banner">
      <img src="https://i.ibb.co/PpR4wVH/IMG-20250525-214650-469.jpg" alt="রেফার ইনকাম ব্যানার" loading="lazy" />
    </div>

    <div class="referral-content">
      <h1>আপনার রেফার ইনকাম সম্পর্কে বিস্তারিত</h1>
      <p>আমাদের প্লাটফর্মে বন্ধুবান্ধবকে রেফার করে আকর্ষণীয় ইনকাম উপভোগ করুন। নিচে রেফার ইনকামের প্রধান আকর্ষণগুলি দেওয়া হল:</p>
      <ul class="referral-income-list">
        <li>প্রত্যেক সফল রেফারে পাবেন ৳২০ মোট নগদ ইনকাম।</li>
        <li>রেফার করে অর্জিত ইনকাম বিনামূল্যে উত্তোলন করতে পারবেন।</li>
        <li>আপনার রেফার লিঙ্ক শেয়ার করুন সোশ্যাল মিডিয়ায় এবং আরও বেশি উপার্জন করুন।</li>
        <li>মাসে সর্বোচ্চ ৳২০০ পর্যন্ত রেফার ইনকাম বোনাস পেতে পারেন।</li>
        <li>স্বয়ংক্রিয় ইনকাম রিপোর্ট আপনার ড্যাশবোর্ডে প্রতিদিন আপডেট হয়।</li>
      </ul>
      <a href="#" class="referral-button">আপনার রেফার লিংক শেয়ার করুন</a>
    </div>
 
</br>
</div>

<!-- কপি ফাংশন -->
<script>
  function copyText(id) {
    const input = document.getElementById(id);
    input.select();
    input.setSelectionRange(0, 99999); // মোবাইলের জন্য
    document.execCommand("copy");
    alert("কপি হয়েছে: " + input.value);
  }
</script>

</div>

    
<!-- ফুটার -->
<footer class="footer">
  <a href="/dashboard" class="footer-item">
    <i class="fas fa-home"></i>
    <span>হোম</span>
  </a>
  <a href="/myteam" class="footer-item">
    <i class="fas fa-users"></i>
    <span>মাই টিম</span>
  </a>
  <a href="/notice" class="footer-item">
    <i class="fas fa-coins"></i>
    <span>ইনকাম</span>
  </a>
  <a href="/helpline" class="footer-item">
    <i class="fas fa-headset"></i>
    <span>সাপোর্ট</span>
  </a>
</footer>

<!-- স্ক্রিপ্ট -->
<script>
  // সাইডবার স্টেট পরিবর্তন
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  
  // সাইডবার স্টেট চেক করে এবং সেটি টগল করা
  if (sidebar.style.left === '0px') {
    sidebar.style.left = '-260px'; // সাইডবার বন্ধ
  } else {
    sidebar.style.left = '0px'; // সাইডবার ওপেন
  }
}

// থ্রি লাইনে ক্লিক করলে সাইডবার খুলে যাবে
document.querySelector('.header-left i').addEventListener('click', toggleSidebar);
  
  // সাইডবার টগল
  document.getElementById('menuToggle').addEventListener('click', function () {
    document.getElementById('sidebar').classList.toggle('active');
  });
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  sidebar.style.left = (sidebar.style.left === '0px') ? '-260px' : '0px';
}
  

</script>

</body>
</html>