
</header>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Registration Page</title>
  <link
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
    rel="stylesheet"
  />
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap"
    rel="stylesheet"
  />
  <style>
    /* Reset and base */
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #667eea, #764ba2);
      color: #333;
      min-height: 10vh;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }
    
    /* Main container */
    .registration-container {
      width: 100%;
      max-width: 480px;
      background: #fff;
      border-radius: 20px;
      box-shadow: 0 25px 50px rgba(90, 70, 202, 0.25);
      padding: 40px 30px;
      margin: 20px 0;
    }
    
    /* Header */
    .registration-header {
      text-align: center;
      margin-bottom: 30px;
    }
    .registration-header h2 {
      font-size: 1.8rem;
      color: #3a3a3a;
      font-weight: 600;
      margin-bottom: 8px;
    }
    .registration-header p {
      color: #6c757d;
      font-size: 0.95rem;
    }
    
    /* Form elements */
    .registration-form {
      display: flex;
      flex-direction: column;
      gap: 18px;
    }
    
    .input-group {
      position: relative;
      display: flex;
      align-items: center;
      background: #f5f7ff;
      padding: 12px 16px;
      border-radius: 12px;
      border: 2px solid transparent;
      transition: all 0.3s ease;
    } 
    .input-group:focus-within {
      border-color: #667eea;
      box-shadow: 0 0 10px rgba(102, 126, 234, 0.5);
      background: #fff;
    }
    .input-group .icon {
      color: #667eea;
      font-size: 18px;
      margin-right: 12px;
      width: 20px;
    }
    .input-group input {
      border: none;
      outline: none;
      font-size: 1rem;
      background: transparent;
      width: 100%;
      color: #333;
      font-weight: 500;
    }
    .input-group input::placeholder {
      color: #a9abc1;
      font-weight: 400;
    }
    
    /* Buttons */
    .btn {
      cursor: pointer;
      font-weight: 600;
      font-size: 1.1rem;
      border-radius: 14px;
      padding: 14px 0;
      border: none;
      transition: all 0.3s ease;
      text-align: center;
    }
    .btn-primary {
      background: linear-gradient(to right, #667eea, #764ba2);
      color: #fff;
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
    }
    .btn-primary:hover {
      background: linear-gradient(to right, #5a6fd1, #6a4198);
      box-shadow: 0 8px 24px rgba(90, 111, 209, 0.6);
    }
    .btn-secondary {
      background: transparent;
      border: 2px solid #667eea;
      color: #667eea;
      margin-top: 8px;
    }
    .btn-secondary:hover {
      background: #667eea;
      color: #fff;
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.5);
    }
    
    /* Responsive adjustments */
    @media (max-width: 520px) {
      .registration-container {
        padding: 30px 20px;
        border-radius: 16px;
      }
    }
  </style>
</head>
<body>
  <div class="registration-container">
    <div class="registration-header">
      <h2>Create Your Account</h2>
      <p>Join us and get started</p>
    </div>
    
    <form class="registration-form" action="{{ route('register_submit') }}" method="POST">
      @csrf
      
      <!-- Referral ID -->
      <div class="input-group">
        <div class="icon"><i class="fas fa-user-friends"></i></div>
        <input type="text" placeholder="Referral ID" id="ref_id" name="ref_by" value="{{ request()->has('by') ? request('by') : '' }}">
      </div>
      
      <!-- Name Fields -->
      <div style="display: flex; gap: 18px;">
        <div class="input-group" style="flex: 1;">
          <div class="icon"><i class="fas fa-user"></i></div>
          <input type="text" name="first_name" placeholder="First Name" id="first_name" required>
        </div>
        <div class="input-group" style="flex: 1;">
          <div class="icon"><i class="fas fa-user"></i></div>
          <input type="text" name="last_name" placeholder="Last Name" id="last_name" required>
        </div>
      </div>
      
      <!-- Email and Phone -->
      <div style="display: flex; gap: 18px;">
        <div class="input-group" style="flex: 1;">
          <div class="icon"><i class="fas fa-envelope"></i></div>
          <input type="email" name="email" placeholder="E-mail Address" id="email" required>
        </div>
        <div class="input-group" style="flex: 1;">
          <div class="icon"><i class="fas fa-phone"></i></div>
          <input name="phone" type="text" placeholder="Phone Number" id="phone" required>
        </div>
      </div>
      
      <!-- Password Fields -->
      <div style="display: flex; gap: 18px;">
        <div class="input-group" style="flex: 1;">
          <div class="icon"><i class="fas fa-lock"></i></div>
          <input type="password" name="password" placeholder="Password" id="password" required>
        </div>
        <div class="input-group" style="flex: 1;">
          <div class="icon"><i class="fas fa-lock"></i></div>
          <input type="password" name="password_confirmation" placeholder="Confirm Password" id="password_confirmation" required>
        </div>
      </div>
      
      <button type="submit" class="btn btn-primary">Register Now</button>
      <a href="/login" class="btn btn-secondary"> Login</a>
    </form>
  </div>
</body>
</html>
         
    <!-- Site Footer-->

@include('user.layout.footer')