<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>LONG LIFE Updating...</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

  <style>
    body {
      font-family: 'Arial', sans-serif;
      background: #f8f9fa;
      margin: 0;
      padding: 0;
    }

    /* হেডার */
    .header {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      padding: 15px 20px 60px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: white;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      border-bottom-left-radius: 80px 30px;
      border-bottom-right-radius: 80px 30px;
      position: relative;
      z-index: 1001;
    }
    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .header-left i, .header-right i {
      font-size: 26px;
      cursor: pointer;
    }
    .header-left span {
      font-size: 22px;
      font-weight: bold;
    }
    
    /* সাইডবার */
.sidebar {
  position: fixed;
  top: 0;
  left: -260px;
  height: 100%;
  width: 260px;
  background: linear-gradient(180deg, #43a047, #2e7d32);
  transition: all 0.3s ease;
  z-index: 9999;
  overflow-y: auto;
  padding-top: 20px;
  box-shadow: 2px 0 8px rgba(0, 0, 0, 0.2);
}

/* সাইডবার লিঙ্ক */
.sidebar a {
  display: flex;
  align-items: center;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  color: white;
  text-decoration: none;
  font-size: 18px;
  transition: background 0.3s ease;
  margin: 0;
  line-height: 1;
}

.sidebar a i {
  margin-right: 10px;
}

.sidebar a:hover {
  background: #16a085;
}

.sidebar a .link-text {
  flex-grow: 1;
  margin-left: 10px;
  text-align: left;
}

.sidebar a .arrow {
  margin-left: auto;
}

/* সাইডবার হেডার */
.sidebar-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 15px; /* হেডারের প্যাডিং কমানো হলো */
  background: linear-gradient(90deg, #4CAF50, #2ecc71);
}

.sidebar-header h2 {
  color: white;
  font-size: 20px;
  margin: 0;
}

/* সাইডবার ক্লোজ বাটন */
.sidebar .close-btn {
  font-size: 30px;
  color: white;
  cursor: pointer;
}

/* সাইডবার লিঙ্কের তালিকা */
.sidebar-links {
  list-style: none;
  padding: 0;
  margin: 0;
}

.sidebar-links li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  border-bottom: 1px solid #fff; /* সাদা দাগ */
}

.sidebar-links li a {
  display: flex;
  align-items: center;
  color: white;
  text-decoration: none;
  font-size: 16px;
  flex-grow: 1;
}

.sidebar-links li a i {
  margin-right: 8px;
  font-size: 18px;
}

/* রেসপন্সিভ */
@media (max-width: 768px) {
  .sidebar {
    width: 230px;
  }
}
.sidebar-user-info {
  padding: 20px 10px;
  border-bottom: 1px solid #ffffff;
  text-align: center;
}

.sidebar-user-info .profile-pic img {
  height: 80px;
  width: 80px;
  object-fit: cover;
  border-radius: 50%;
  border: 2px solid white;
  margin-bottom: 10px;
}

.sidebar-user-info .decorative-line {
  height: 20px;
  margin: 0 auto 10px;
  display: block;
}

.sidebar-user-info .user-name {
  margin: 5px 0;
  font-size: 18px;
  color: #ffffff;
  font-weight: bold;
}

.sidebar-user-info .user-data {
  margin-top: 8px;
  color: #ffffff;
  font-size: 14px;
}

.sidebar-user-info .user-data p {
  margin: 4px 0;
}

.sidebar-user-info .account-status {
  margin-top: 8px;
  padding: 6px 20px;
  background: linear-gradient(135deg, #6a11cb, #2575fc);
  border-radius: 20px;
  display: inline-block;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  font-weight: bold;
}


.user-info {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-top: 20px;
}

.user-info img {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  border: 3px solid #ffffff;
  object-fit: cover; /* ইমেজকে সুন্দরভাবে কাটবে */
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* হালকা ছায়া */
}

.user-info h3 {
  margin: 10px 0 5px;
  font-size: 20px;
  color: #ffffff;
  font-weight: 600;
}

.user-info p {
  font-size: 14px;
  color: #ecf0f1;
  margin: 2px 0;
}
    
    /* ফুটার */
    .footer {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      display: flex;
      justify-content: space-around;
      align-items: center;
      padding: 10px 0;
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      z-index: 999;
      height: 65px;
      box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
    }
    .footer-item {
      color: white;
      text-decoration: none;
      font-size: 13px;
      display: flex;
      flex-direction: column;
      align-items: center;
      flex: 1;
      position: relative;
    }
    .footer-item i {
      font-size: 22px;
      margin-bottom: 3px;
    }
    .footer-item:not(:last-child)::after {
      content: "";
      position: absolute;
      right: 0;
      top: 10px;
      bottom: 10px;
      width: 1px;
      background: rgba(255,255,255,0.5);
    }

    
</style>
</head>

<body>



<!-- সাইডবারের কোড -->
<div class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <h2>মেনু</h2>
    <button class="close-sidebar" onclick="toggleSidebar()">×</button>
  </div>
 
 <div class="sidebar-user-info text-center">
    <div class="profile-pic">
        <img src="{{ asset('uploads/profile_images/' . Auth::user()->profile_image) }}" alt="User">
    </div>
    
    
    <h5 class="user-name">{{auth()->user()->fname}} {{auth()->user()->lname}}</h5>
    
    <div class="user-data">
        <p class="m-0">Refer ID: {{ auth()->user()->ref_code }}</p>
        <p class="m-0">Joined: {{ auth()->user()->created_at->format('M D Y') }}</p>
        
        <div class="account-status">
            একাউন্ট সেটিংস : 
            <span style="color: #ff4d4d">
                🎉
            </span>
        </div>
    </div>
</div>
    
  <ul class="sidebar-links">
  <li>
    <a href="/dashboard">
      <i class="fas fa-home"></i> হোম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/profile">
      <i class="fas fa-user"></i> প্রোফাইল
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/notice">
      <i class="fas fa-coins""></i>আমার ইনকাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="{{ app('telegram_url') }}">
      <i class="fab fa-telegram"></i> টেলিগ্রাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/withdraw/create">
      <i class="fas fa-money-bill-wave"></i> উত্তোলন 
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/helpline">
      <i class="fas fa-headset"></i> সাপোর্ট
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/raferlink">
      <i class="fas fa-user-cog"></i> রেফার করি
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/logout">
      <i class="fas fa-sign-out-alt"></i> লগ আউট
      <span class="arrow">&gt;</span>
    </a>
  </li>
</ul>
<br>
<br>
</div>

<!-- হেডার -->
<div class="header">
  <div class="header-left">
    <i class="fas fa-bars" id="menuToggle"></i>
    <span>LONG LIFE</span>
  </div>
  <div class="header-right">
    <i class="fas fa-bell"></i>
  </div>
</div>


    <!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>অফার পেজ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* অপারেটর লোগো গুলি এক লাইনে দেখানোর জন্য */
        .operator-logos {
            display: flex;
            justify-content: space-evenly;  /* সমানভাবে লোগোগুলি সজ্জিত হবে */
            margin-bottom: 20px;
        }

        .operator-logo {
            width: 70px; /* সব লোগোর জন্য একি সাইজ */
            height: 70px;
            object-fit: contain;
            cursor: pointer;
            border: 2px solid transparent;
            border-radius: 10px;
            transition: transform 0.3s ease;
        }



        .operator-logo:hover {
            transform: scale(1.1); /* হোভার করলে লোগোটি একটু বড় হবে */
        }

        .active-logo {
            border-color: #0d6efd;
            background-color: #e7f1ff;
        }

        /* অফার বক্সের অপারেটর লোগো */
.offer-logo {
    border-radius: 10px; /* কোণাগুলো রাউন্ডেড করবে */
    object-fit: cover;  /* লোগোটি ভালোভাবে ফিট হবে */
    width: 40px;        /* অফার বক্সের লোগো সাইজ নির্ধারণ করুন */
    height: 40px;       /* অফার বক্সের লোগো সাইজ নির্ধারণ করুন */
}

        /* মোবাইল ফ্রেন্ডলি: স্ক্রীনের আকার অনুযায়ী লোগো সাইজ সামঞ্জস্য */
        @media (max-width: 767px) {
            .operator-logo {
                width: 60px; /* মোবাইলের জন্য সাইজ সামঞ্জস্য */
                height: 60px;
            }
        }
    </style>
</head>
<body>

<div style="max-width: 95%; background-color: #ffe6e6; border: 2px solid #ff4d4d; border-radius: 10px; padding: 15px; text-align: center; margin: 15px auto; box-shadow: 0px 0px 10px rgba(0,0,0,0.1); font-family: sans-serif;">
  <h3 style="color: #cc0000; font-size: 18px; margin-bottom: 10px;"><b>⚠️ জরুরী নোটিশ ⚠️</h3>
  <p style="color: #cc0000; font-size: 16px; line-height: 1.5;">প্রতিটি অফার হিট করার আগে অবশ্যই লোন পরিশোধ করে অফার হিট করবেন. <br> সিমে যদি কোন ইমারজেন্সি লোন থাকে তাহলে অফার যাবে না সরাসরি ব্যালেন্সে টাকা যুক্ত হবে⛔ 
    
</b>

</p>
 
<div style="background-color: #eef802; color:red;"> অফার অর্ডার টাইম: 10:00 AM - 10:00 PM. </div>
</div>
</div>


<div class="container my-4">
    <!-- অপারেটর লোগো গুলি এক লাইনে -->
    <div class="operator-logos">
        <img src="https://longlifenetwork.shop/user/assets/images/gp.png" id="Grameenphone" class="operator-logo" alt="Grameenphone">
        <img src="https://longlifenetwork.shop/user/assets/images/ri.png" id="Robi" class="operator-logo" alt="Robi">
        <img src="https://longlifenetwork.shop/user/assets/images/al.png" id="Airtel" class="operator-logo" alt="Airtel">
        <img src="https://longlifenetwork.shop/user/assets/images/bl.png" id="Banglalink" class="operator-logo" alt="Banglalink">
    </div>

    <div id="offersContainer" class="row"></div>
</div>

<!-- Modal -->
<div class="modal fade" id="offerModal" tabindex="-1" aria-labelledby="offerModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="offerModalLabel">অফার বিস্তারিত</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="বন্ধ করুন"></button>
      </div>
      <div class="modal-body">
        <p id="offerModalDescription"></p>
      </div>
      <div class="modal-footer">
        <a href="https://wa.me/qr/THH4PB3GM5ZEK1" id="buyNowBtn" target="_blank" class="btn btn-success">Buy Now</a>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">বন্ধ করুন</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Operator logos
var operatorLogos = {
    "Grameenphone": "https://longlifenetwork.shop/user/assets/images/gp.png",
    "Robi": "https://longlifenetwork.shop/user/assets/images/ri.png",
    "Airtel": "https://longlifenetwork.shop/user/assets/images/al.png",
    "Banglalink": "https://longlifenetwork.shop/user/assets/images/bl.png"
};

// Operator contact numbers for WhatsApp (format: country code+number)
var operatorContacts = {
    "Grameenphone": "8801890665326",
    "Robi": "8801890665326",
    "Airtel": "8801890665326",
    "Banglalink": "8801890665326"
};

// Dummy offers data (10 offers per operator)
var offersData = {
    "Grameenphone": [
        { title: "5 GB+100MIN 7D", description: "জিপি ৫ জিবি ১০০ মিনিট মেয়াদ ৭ দিন অল বিডি ২৩০৳ ক্যাশ ব্যাক ৪৳ ", price: "230 TK", cashback: "4 TK" },
        { title: "8GB+100MIN 7D", description: "জিপি ৮ জিবি ১০০ মিনিট ৭ দিন অল বিডি ২৫০৳ ক্যাশ ব্যাক ৮৳", price: "250 TK", cashback: "8 TK" },
        { title: "50GB+200MIN", description: "জিপি ৫০ জিবি ২০০ মিনিট ৩০ দিন অল বিডি ৭০০৳ ক্যাশ ব্যাক ৭০৳", price: "700 TK", cashback: "70 TK" },
        { title: "100GB+1600MIN", description: "জিপি ১০০ জিবি ১৬০০ মিনিট ৩০ দিন অল বিডি ৯৫০৳ ক্যাশ ব্যাক ৭০৳", price: "950 TK", cashback: "70 TK" },
        { title: "500 MIN 30D", description: "জিপি ৫০০ মিনিট ৩০ দিন অল বিডি ৩৭০৳ ক্যাশ ব্যাক ১৫৳", price: "370 TK", cashback: "15 TK" },
        { title: "80/90 GB 3D", description: "জিপি ৮০/৯০ জিবি ৩০ দিন অল বিডি ৫৯৯৳ ক্যাশ ব্যাক ১৪৳", price: "599 TK", cashback: "14 TK" },
        { title: "200 GB 30D", description: "জিপি ২০০ জিবি ৩০ দিন অল বিডি ৭৪৯৳ ক্যাশ ব্যাক ৪০৳", price: "749 TK", cashback: "40 TK" },
        { title: "1150 MIN 30D", description: "জিপি ১১৫০ মিনিট ৩০ দিন অল বিডি ৭৪৯৳ ক্যাশ ব্যাক ৫০৳", price: "749 TK", cashback: "50 TK" },
        { title: "20 GB 30D", description: "জিপি ২০ জিবি অল বিডি ৪৯০৳ ক্যাশ ব্যাক ১০৳", price: "490 TK", cashback: "10 TK" },
        { title: "500 MIN 30D", description: "জিপি ৫০০ মিনিট ৩০ দিন অল বিডি ৩৭০৳ ক্যাশ ব্যাক ২৫৳", price: "370 TK", cashback: "25 TK" }
    ],


    "Robi": [
        { title: "Offer 1", description: "Details of Offer 1", price: "30 TK", cashback: "2 TK" },
        { title: "Offer 2", description: "Details of Offer 2", price: "50 TK", cashback: "3 TK" },
        { title: "Offer 3", description: "Details of Offer 3", price: "100 TK", cashback: "5 TK" },
        { title: "Offer 4", description: "Details of Offer 4", price: "150 TK", cashback: "7 TK" },
        { title: "Offer 5", description: "Details of Offer 5", price: "200 TK", cashback: "10 TK" },
        { title: "Offer 6", description: "Details of Offer 6", price: "250 TK", cashback: "12 TK" },
        { title: "Offer 7", description: "Details of Offer 7", price: "300 TK", cashback: "15 TK" },
        { title: "Offer 8", description: "Details of Offer 8", price: "350 TK", cashback: "18 TK" },
        { title: "Offer 9", description: "Details of Offer 9", price: "400 TK", cashback: "20 TK" },
        { title: "Offer 10", description: "Details of Offer 10", price: "500 TK", cashback: "25 TK" }
    ],
    "Airtel": [
        { title: "Offer 1", description: "Details of Offer 1", price: "30 TK", cashback: "2 TK" },
        { title: "Offer 2", description: "Details of Offer 2", price: "50 TK", cashback: "3 TK" },
        { title: "Offer 3", description: "Details of Offer 3", price: "100 TK", cashback: "5 TK" },
        { title: "Offer 4", description: "Details of Offer 4", price: "150 TK", cashback: "7 TK" },
        { title: "Offer 5", description: "Details of Offer 5", price: "200 TK", cashback: "10 TK" },
        { title: "Offer 6", description: "Details of Offer 6", price: "250 TK", cashback: "12 TK" },
        { title: "Offer 7", description: "Details of Offer 7", price: "300 TK", cashback: "15 TK" },
        { title: "Offer 8", description: "Details of Offer 8", price: "350 TK", cashback: "18 TK" },
        { title: "Offer 9", description: "Details of Offer 9", price: "400 TK", cashback: "20 TK" },
        { title: "Offer 10", description: "Details of Offer 10", price: "500 TK", cashback: "25 TK" }
    ],
    "Banglalink": [
        { title: "Offer 1", description: "Details of Offer 1", price: "30 TK", cashback: "2 TK" },
        { title: "Offer 2", description: "Details of Offer 2", price: "50 TK", cashback: "3 TK" },
        { title: "Offer 3", description: "Details of Offer 3", price: "100 TK", cashback: "5 TK" },
        { title: "Offer 4", description: "Details of Offer 4", price: "150 TK", cashback: "7 TK" },
        { title: "Offer 5", description: "Details of Offer 5", price: "200 TK", cashback: "10 TK" },
        { title: "Offer 6", description: "Details of Offer 6", price: "250 TK", cashback: "12 TK" },
        { title: "Offer 7", description: "Details of Offer 7", price: "300 TK", cashback: "15 TK" },
        { title: "Offer 8", description: "Details of Offer 8", price: "350 TK", cashback: "18 TK" },
        { title: "Offer 9", description: "Details of Offer 9", price: "400 TK", cashback: "20 TK" },
        { title: "Offer 10", description: "Details of Offer 10", price: "500 TK", cashback: "25 TK" }
    ]
};
// Function to load and display offers for the selected operator
function showOffers(operator) {
    document.querySelectorAll('.operator-logo').forEach(function(img) {
        img.classList.remove('active-logo');
    });
    var selectedLogo = document.getElementById(operator);
    if (selectedLogo) {
        selectedLogo.classList.add('active-logo');
    }

    var container = document.getElementById('offersContainer');
    container.innerHTML = '';

    var offers = offersData[operator];
    if (!offers) return;

    offers.forEach(function(offer, index) {
        var col = document.createElement('div');
        col.className = 'col-12 col-md-6 col-lg-4 mb-4';

        var card = document.createElement('div');
        card.className = 'card h-100';

        var cardBody = document.createElement('div');
        cardBody.className = 'card-body d-flex align-items-center justify-content-between';

        var infoDiv = document.createElement('div');
        infoDiv.className = 'd-flex align-items-center';

        var logoImg = document.createElement('img');
        logoImg.src = operatorLogos[operator];
        logoImg.alt = operator + ' Logo';
        logoImg.className = 'offer-logo me-3';

        var textDiv = document.createElement('div');
        var titleEl = document.createElement('h5');
        titleEl.textContent = offer.title;
        var detailsEl = document.createElement('p');
        detailsEl.innerHTML = '<strong>Price:</strong> ' + offer.price + '<br><strong>Cashback:</strong> ' + offer.cashback;

        textDiv.appendChild(titleEl);
        textDiv.appendChild(detailsEl);

        infoDiv.appendChild(logoImg);
        infoDiv.appendChild(textDiv);

        var btn = document.createElement('button');
        btn.className = 'btn btn-primary btn-sm btn-details';
        btn.textContent = 'See Details';
        btn.dataset.operator = operator;
        btn.dataset.index = index;

        cardBody.appendChild(infoDiv);
        cardBody.appendChild(btn);
        card.appendChild(cardBody);
        col.appendChild(card);
        container.appendChild(col);
    });
}

// Event listener for operator logo clicks
document.querySelectorAll('.operator-logo').forEach(function(img) {
    img.addEventListener('click', function() {
        var operator = this.id;
        showOffers(operator);
    });
});

// Event delegation for See Details buttons
document.getElementById('offersContainer').addEventListener('click', function(e) {
    if (e.target && e.target.matches('button.btn-details')) {
        var operator = e.target.dataset.operator;
        var index = e.target.dataset.index;
        var offer = offersData[operator][index];

        document.getElementById('offerModalLabel').textContent = offer.title;
        document.getElementById('offerModalDescription').textContent = offer.description;

        var phone = operatorContacts[operator];
        var text = encodeURIComponent('আমি "' + offer.description + '" অফারে আগ্রহী।');
        var waLink = 'https://api.whatsapp.com/send?phone=' + phone + '&text=' + text;
        document.getElementById('buyNowBtn').href = waLink;

        var offerModal = new bootstrap.Modal(document.getElementById('offerModal'));
        offerModal.show();
    }
});

// Initialize by showing offers of Grameenphone on page load
window.addEventListener('DOMContentLoaded', function() {
    showOffers('Grameenphone');
});
</script>

</body>
</html>
<br>
<br>
    

<!-- ফুটার -->
<footer class="footer">
  <a href="/dashboard" class="footer-item">
    <i class="fas fa-home"></i>
    <span>হোম</span>
  </a>
  <a href="/myteam" class="footer-item">
    <i class="fas fa-users"></i>
    <span>মাই টিম</span>
  </a>
  <a href="/notice" class="footer-item">
    <i class="fas fa-coins"></i>
    <span>ইনকাম</span>
  </a>
  <a href="/helpline" class="footer-item">
    <i class="fas fa-headset"></i>
    <span>সাপোর্ট</span>
  </a>
</footer>

<!-- স্ক্রিপ্ট -->
<script>
  // সাইডবার স্টেট পরিবর্তন
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  
  // সাইডবার স্টেট চেক করে এবং সেটি টগল করা
  if (sidebar.style.left === '0px') {
    sidebar.style.left = '-260px'; // সাইডবার বন্ধ
  } else {
    sidebar.style.left = '0px'; // সাইডবার ওপেন
  }
}

// থ্রি লাইনে ক্লিক করলে সাইডবার খুলে যাবে
document.querySelector('.header-left i').addEventListener('click', toggleSidebar);
  
  // সাইডবার টগল
  document.getElementById('menuToggle').addEventListener('click', function () {
    document.getElementById('sidebar').classList.toggle('active');
  });
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  sidebar.style.left = (sidebar.style.left === '0px') ? '-260px' : '0px';
}
  

</script>

</body>
</html>