
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>LONG LIFE - WITHDRAW CREATE</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

  <style>
   
   
    body {
      font-family: 'Arial', sans-serif;
      background: #f8f9fa;
      margin: 0;
      padding: 0;
    }

    /* হেডার */
    .header {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      padding: 15px 20px 60px 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      color: white;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
      border-bottom-left-radius: 80px 30px;
      border-bottom-right-radius: 80px 30px;
      position: relative;
      z-index: 1001;
    }
    .header-left {
      display: flex;
      align-items: center;
      gap: 10px;
    }
    .header-left i, .header-right i {
      font-size: 26px;
      cursor: pointer;
    }
    .header-left span {
      font-size: 22px;
      font-weight: bold;
    }
    
    /* সাইডবার */
.sidebar {
  position: fixed;
  top: 0;
  left: -260px;
  height: 100%;
  width: 260px;
  background: linear-gradient(180deg, #43a047, #2e7d32);
  transition: all 0.3s ease;
  z-index: 9999;
  overflow-y: auto;
  padding-top: 20px;
  box-shadow: 2px 0 8px rgba(0, 0, 0, 0.2);
}

/* সাইডবার লিঙ্ক */
.sidebar a {
  display: flex;
  align-items: center;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  color: white;
  text-decoration: none;
  font-size: 18px;
  transition: background 0.3s ease;
  margin: 0;
  line-height: 1;
}

.sidebar a i {
  margin-right: 10px;
}

.sidebar a:hover {
  background: #16a085;
}

.sidebar a .link-text {
  flex-grow: 1;
  margin-left: 10px;
  text-align: left;
}

.sidebar a .arrow {
  margin-left: auto;
}

/* সাইডবার হেডার */
.sidebar-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  padding: 10px 15px; /* হেডারের প্যাডিং কমানো হলো */
  background: linear-gradient(90deg, #4CAF50, #2ecc71);
}

.sidebar-header h2 {
  color: white;
  font-size: 20px;
  margin: 0;
}

/* সাইডবার ক্লোজ বাটন */
.sidebar .close-btn {
  font-size: 30px;
  color: white;
  cursor: pointer;
}

/* সাইডবার লিঙ্কের তালিকা */
.sidebar-links {
  list-style: none;
  padding: 0;
  margin: 0;
}

.sidebar-links li {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 8px 15px; /* উপরে-নিচে কম প্যাডিং */
  border-bottom: 1px solid #fff; /* সাদা দাগ */
}

.sidebar-links li a {
  display: flex;
  align-items: center;
  color: white;
  text-decoration: none;
  font-size: 16px;
  flex-grow: 1;
}

.sidebar-links li a i {
  margin-right: 8px;
  font-size: 18px;
}

/* রেসপন্সিভ */
@media (max-width: 768px) {
  .sidebar {
    width: 230px;
  }
}
.sidebar-user-info {
  padding: 20px 10px;
  border-bottom: 1px solid #ffffff;
  text-align: center;
}

.sidebar-user-info .profile-pic img {
  height: 80px;
  width: 80px;
  object-fit: cover;
  border-radius: 50%;
  border: 2px solid white;
  margin-bottom: 10px;
}

.sidebar-user-info .decorative-line {
  height: 20px;
  margin: 0 auto 10px;
  display: block;
}

.sidebar-user-info .user-name {
  margin: 5px 0;
  font-size: 18px;
  color: #ffffff;
  font-weight: bold;
}

.sidebar-user-info .user-data {
  margin-top: 8px;
  color: #ffffff;
  font-size: 14px;
}

.sidebar-user-info .user-data p {
  margin: 4px 0;
}

.sidebar-user-info .account-status {
  margin-top: 8px;
  padding: 6px 20px;
  background: linear-gradient(135deg, #6a11cb, #2575fc);
  border-radius: 20px;
  display: inline-block;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
  font-weight: bold;
}


.user-info {
  display: flex;
  flex-direction: column;
  align-items: center;
  margin-top: 20px;
}

.user-info img {
  width: 80px;
  height: 80px;
  border-radius: 50%;
  border: 3px solid #ffffff;
  object-fit: cover; /* ইমেজকে সুন্দরভাবে কাটবে */
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* হালকা ছায়া */
}

.user-info h3 {
  margin: 10px 0 5px;
  font-size: 20px;
  color: #ffffff;
  font-weight: 600;
}

.user-info p {
  font-size: 14px;
  color: #ecf0f1;
  margin: 2px 0;
}
    
    /* ফুটার */
    .footer {
      background: linear-gradient(90deg, #4CAF50, #2ecc71);
      display: flex;
      justify-content: space-around;
      align-items: center;
      padding: 10px 0;
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      z-index: 999;
      height: 65px;
      box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
    }
    .footer-item {
      color: white;
      text-decoration: none;
      font-size: 13px;
      display: flex;
      flex-direction: column;
      align-items: center;
      flex: 1;
      position: relative;
    }
    .footer-item i {
      font-size: 22px;
      margin-bottom: 3px;
    }
    .footer-item:not(:last-child)::after {
      content: "";
      position: absolute;
      right: 0;
      top: 10px;
      bottom: 10px;
      width: 1px;
      background: rgba(255,255,255,0.5);
    }

    
</style>
</head>

<body>



<!-- সাইডবারের কোড -->
<div class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <h2>মেনু</h2>
    <button class="close-sidebar" onclick="toggleSidebar()">×</button>
  </div>
 
 <div class="sidebar-user-info text-center">
    <div class="profile-pic">
        <img src="{{ asset('uploads/profile_images/' . Auth::user()->profile_image) }}" alt="User">
    </div>
    
    
    <h5 class="user-name">{{auth()->user()->fname}} {{auth()->user()->lname}}</h5>
    
    <div class="user-data">
        <p class="m-0">Refer ID: {{ auth()->user()->ref_code }}</p>
        <p class="m-0">Joined: {{ auth()->user()->created_at->format('M D Y') }}</p>
        
        <div class="account-status">
            একাউন্ট সেটিংস : 
            <span style="color: #ff4d4d">
                🎉
            </span>
        </div>
    </div>
</div>
    
  <ul class="sidebar-links">
  <li>
    <a href="/dashboard">
      <i class="fas fa-home"></i> হোম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/profile">
      <i class="fas fa-user"></i> প্রোফাইল
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/notice">
      <i class="fas fa-coins""></i>আমার ইনকাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="{{ app('telegram_url') }}">
      <i class="fab fa-telegram"></i> টেলিগ্রাম
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/withdraw/create">
      <i class="fas fa-money-bill-wave"></i> উত্তোলন 
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/helpline">
      <i class="fas fa-headset"></i> সাপোর্ট
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/raferlink">
      <i class="fas fa-user-cog"></i> রেফার করি
      <span class="arrow">&gt;</span>
    </a>
  </li>
  <li>
    <a href="/logout">
      <i class="fas fa-sign-out-alt"></i> লগ আউট
      <span class="arrow">&gt;</span>
    </a>
  </li>
</ul>
<br>
<br>
</div>

<!-- হেডার -->
<div class="header">
  <div class="header-left">
    <i class="fas fa-bars" id="menuToggle"></i>
    <span>LONG LIFE</span>
  </div>
  <div class="header-right">
    <i class="fas fa-bell"></i>
  </div>
</div>

<div style="max-width: 500px; margin: 10px auto 30px auto; padding: 15px;">
    <!-- ব্যালেন্স কার্ড -->
    <div style="background: linear-gradient(135deg, #00c6ff, #0072ff); color: white; border-radius: 12px; padding: 20px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1); margin-bottom: 20px;">
        <div style="text-align: center;">
            <h2 style="margin-bottom: 10px; color: #e0e0e0;">আপনার বর্তমান ব্যালেন্স</h2>
            <h4 style="font-size: 1.75rem; font-weight: bold;">{{auth()->user()->balance}}  ৳</h4>
        </div>
    </div>
<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>উইথড্র ফর্ম</title>
<!-- FontAwesome for wallet icon -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />
<style>
    /* Style for বিকাশ এবং নগদ radio buttons in one row side by side */
    /* Target the withdraw_method radio buttons container */
    .radio-group.text-center {
      display: flex !important;
      justify-content: center;
      gap: 10px;
      flex-wrap: nowrap;
    }
    /* Inside that group, the labels should take about half width and not float */
    .radio-group.text-center > label.radio-container {
      float: none !important;
      width: 48% !important;
      box-sizing: border-box;
      cursor: pointer;
      background: #fff0f6;
      border: 2px solid transparent;
      border-radius: 12px;
      padding: 10px 0;
      display: flex;
      flex-direction: column;
      align-items: center;
      transition: border-color 0.3s, box-shadow 0.3s;
    }
    .radio-group.text-center > label.radio-container:hover {
      border-color: #e91e63;
      box-shadow: 0 0 8px rgba(233, 30, 99, 0.6);
    }
    .radio-group.text-center > label.radio-container input[type="radio"] {
      display: none;
    }
    .radio-group.text-center > label.radio-container input[type="radio"]:checked + span.radio-icon,
    .radio-group.text-center > label.radio-container input[type="radio"]:checked + span.radio-label {
      border-color: #e91e63;
      color: #e91e63;
      font-weight: 700;
    }
    .radio-group.text-center > label.radio-container span.radio-icon img {
      max-width: 150px;
      pointer-events: none;
      user-select: none;
    }
    .radio-group.text-center > label.radio-container span.radio-label {
      margin-top: 8px;
      font-weight: 600;
      font-size: 1rem;
      color: #333;
    }

    /* For টাকা সিলেক্ট box style in a grid, 2 per row and smaller */
    /* Target the req_amount radio-group */
    .form-group.text-wrap.sncd .radio-group.text-center {
      display: grid !important;
      grid-template-columns: repeat(2, 1fr);
      gap: 12px;
      justify-items: center;
      margin-top: 8px;
    }
    /* Labels inside should appear as boxes with background and padding, smaller */
    .form-group.text-wrap.sncd .radio-group.text-center > label.radio-container {
      min-width: 120px !important;
      max-width: 120px !important;
      background-color: #6c757d !important;
      border-radius: 12px !important;
      color: white !important;
      cursor: pointer;
      padding: 12px 8px !important;
      user-select: none;
      display: flex;
      flex-direction: column;
      align-items: center;
      border: 2px solid transparent;
      transition: background-color 0.3s, border-color 0.3s, box-shadow 0.3s;
      text-align: center;
    }
    .form-group.text-wrap.sncd .radio-group.text-center > label.radio-container:hover {
      background-color: #5a6268 !important;
      border-color: #ff4081 !important;
      box-shadow: 0 0 8px rgba(255, 64, 129, 0.7);
    }
    .form-group.text-wrap.sncd .radio-group.text-center > label.radio-container input[type="radio"] {
      display: none;
    }
    .form-group.text-wrap.sncd .radio-group.text-center > label.radio-container input[type="radio"]:checked + span.radio-label {
      border-color: #ff4081 !important;
      background-color: #ff4081 !important;
      color: white !important;
      font-weight: 700 !important;
      box-shadow: 0 0 10px rgba(255, 64, 129, 0.8);
      border-radius: 12px !important;
      display: block;
      width: 100%;
      padding: 9px 0;
      font-size: 1rem;
    }
    .form-group.text-wrap.sncd .radio-group.text-center > label.radio-container span.radio-label {
      cursor: pointer;
      font-size: 1rem;
    }
    .form-group.text-wrap.sncd .radio-group.text-center > label.radio-container span.radio-label .text-danger {
      font-size: 0.8rem;
      color: #ffccd5 !important;
      font-weight: normal;
    }

    /* Submit button smaller and neat */
    .d-flex.justify-content-center.mt-3 button.btn.btn-success.btn-block.py-3 {
      border-radius: 50px !important;
      font-size: 1.2rem !important;
      padding: 12px 30px !important;
      font-weight: 700 !important;
      box-shadow: 0 4px 12px rgba(40, 167, 69, 0.6) !important;
      transition: background-color 0.3s ease !important;
      cursor: pointer;
      max-width: 300px;
      width: 100%;
      margin: auto;
      display: block;
    }
    .d-flex.justify-content-center.mt-3 button.btn.btn-success.btn-block.py-3:hover {
      background-color: #218838 !important;
      box-shadow: 0 6px 15px rgba(33, 136, 56, 0.85) !important;
    }

    /* Stylish number input label */
    label[for="withdraw_to_number"] {
      font-weight: 700;
      font-size: 1.15rem;
      color: white;
      background-color: #ffc107;
      padding: 14px 20px;
      border-radius: 15px;
      display: block;
      width: 100%;
      box-sizing: border-box;
      margin-bottom: 1rem;
      text-align: center;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      letter-spacing: 0.5px;
      text-shadow: 0 1px 2px rgba(0,0,0,0.25);
    }

    input#withdraw_to_number.form-control {
      border: 2px solid #ffbb00 !important;
      border-radius: 50px !important;
      padding: 14px 20px;
      font-size: 1.15rem;
      transition: box-shadow 0.3s ease;
      box-sizing: border-box;
      width: 100%;
      max-width: 400px;
      margin: auto;
      display: block;
    }
    input#withdraw_to_number.form-control::placeholder {
      color: #b59c00;
      font-weight: 500;
    }
    input#withdraw_to_number.form-control:focus {
      outline: none;
      box-shadow: 0 0 12px #ffbb00;
      border-color: #e6ac00;
    }
</style>
</head>
<body>

    <!-- উইথড্র ফর্ম -->
    <div style="background: #ffffff; box-shadow: 0 4px 15px rgba(0,0,0,0.1); border-radius: 12px; overflow: hidden; max-width: 650px; margin: auto;">
        <div style="background: linear-gradient(45deg, #ff4081, #e91e63); color: white; padding: 15px; text-align: center;">
            <h4 style="margin: 0; font-weight: bold;">উইথড্র ফর্ম পূরণ করুন</h4>
        </div>

        <div class="card">
            <div class="card-body p-4 pt-2 text-center">
                <form action="{{ route('withdrawCreate_submit') }}" method="post" enctype="multipart/form-data" class="contact-form">
                    @csrf
                    <div class="form-group col-lg-12" style="margin-bottom: 0;">
                        <div class="radio-group text-center main-balance">
                            <label class="radio-container" style="width: 100%;">
                                <div>
                                    <span class="radio-icon"><i class="fas fa-wallet fa-3x p-2"></i></span>
                                </div>
                                <div>
                                    <span class="radio-label">Main Balance</span>
                                </div>
                                <div>
                                    <small class="" style="color: #FFFF000">৳{{auth()->user()->balance}}</small>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div class="form-group col-lg-12 dhvbdhvb" style="margin-bottom: 0;overflow: hidden">
                        <label class="label-center  p-3 rounded bg-warning my-2 text-white text-bolder w-100">
                            যে কোনো একটি মাধ্যমে বেছেনিন Withdraw দিতে *</label>
                        <div class="radio-group text-center">
                            <label class="radio-container" style="width: 49%;float: left;margin-right: 2%">
                                <input type="radio" name="withdraw_method" value="bkash">
                                <span class="radio-icon"><img src="{{ asset('user/assets/gateways/bkash.png') }}" width="150px"></span>
                                <span class="radio-label">বিকাশ operator</span>
                            </label>
                            <label class="radio-container" style="width: 49%;float: left;">
                                <input type="radio" name="withdraw_method" value="nagad">
                                <span class="radio-icon"><img src="{{ asset('user/assets/gateways/nagad.png') }}" width="150px"></span>
                                <span class="radio-label">নগদ operator</span>
                            </label>
                        </div>
                    </div>

                    <div class="form-group col-lg-12" style="margin-bottom: 0;">
                        <label for="withdraw_to_number" class="label-center">
                            টাকা পাওার জন্য আপনার নাম্বার টি লেখুন *</label>
                        <input type="text" class="form-control rounded-0" id="withdraw_to_number" name="withdraw_to_number" value="" placeholder="আপনার নাম্বার প্রদান করুন" style="border-radius: 50px !important;">
                    </div>

                    <div class="form-group col-lg-12 text-wrap sncd" style="margin-bottom: 0;">
                        <label for="req_amount" class="label-center p-3 rounded bg-warning my-4 text-white text-bolder w-100" style="font-size:1.1rem;">
                            টাকার পরিমান সিলেক্ট করোণ
                        </label>
                        <div class="radio-group text-center">
                            <label style="min-width: 120px" class="radio-container bg-secondary" title="Your minimum withdraw limit is ৳1000">
                                <div><input  type="radio" name="req_amount" value="10:0"></div>
                                <span class="radio-label">Tk.10 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.0)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary " title="Your minimum withdraw limit is ৳1000">
                                <div><input  type="radio" name="req_amount" value="330:30"></div>
                                <span class="radio-label">Tk.330 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.30)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary " title="Your minimum withdraw limit is ৳1000">
                                <div><input  type="radio" name="req_amount" value="440:40"></div>
                                <span class="radio-label">Tk.440 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.40)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary " title="Your minimum withdraw limit is ৳1000">
                                <div><input  type="radio" name="req_amount" value="550:50"></div>
                                <span class="radio-label">Tk.550 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.50)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary " title="Your minimum withdraw limit is ৳1000">
                                <div><input  type="radio" name="req_amount" value="1100:100"></div>
                                <span class="radio-label">Tk.1100 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.100)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary " title="Your minimum withdraw limit is ৳1000">
                                <div><input  type="radio" name="req_amount" value="2200:200"></div>
                                <span class="radio-label">Tk.2200 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.200)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary ">
                                <div><input  type="radio" name="req_amount" value="3300:300"></div>
                                <span class="radio-label">Tk.3300 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.300)</span></span>
                            </label>
                            <label style="min-width: 120px" class="radio-container  bg-secondary ">
                                <div><input  type="radio" name="req_amount" value="4400:400"></div>
                                <span class="radio-label">Tk.4400 <br> <span class="text-danger" style="font-size: 12px;">
                                                            (Charge: Tk.400)</span></span>
                           </label>
                        </div>
                    </div>

                    <div class="d-flex justify-content-center mt-3">
                        <button class="btn btn-success btn-block py-3" type="submit">
                            <span>আপনার Withdraw সফল করুণ</span>
                        </button>
                    </div>
                </form>
            </div>


                    </div>
                <!-- Withdrawal Notice -->
                <div style="margin-top: 25px;">
                    <div style="background-color: #e3f2fd; color: #0d47a1; border-radius: 8px; padding: 20px;">
                        <ul style="margin: 0; padding-left: 20px; list-style-type: square;">
                            <li>সর্বনিম্ন ১০৳ উইথড্র করতে পারবেন।</li>
                            <li>৫% চার্জ প্রযোজ্য।</li>
                            <li>পেমেন্ট টাইম ১ কার্যদিবস।</li>
                        </ul>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>
    
    
    <br><br><br>
    
    
    
    
    

<!-- ফুটার -->
<footer class="footer">
  <a href="/dashboard" class="footer-item">
    <i class="fas fa-home"></i>
    <span>হোম</span>
  </a>
  <a href="/myteam" class="footer-item">
    <i class="fas fa-users"></i>
    <span>মাই টিম</span>
  </a>
  <a href="/notice" class="footer-item">
    <i class="fas fa-coins"></i>
    <span>ইনকাম</span>
  </a>
  <a href="/helpline" class="footer-item">
    <i class="fas fa-headset"></i>
    <span>সাপোর্ট</span>
  </a>
</footer>

<!-- স্ক্রিপ্ট -->




<script>
  // সাইডবার স্টেট পরিবর্তন
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  
  // সাইডবার স্টেট চেক করে এবং সেটি টগল করা
  if (sidebar.style.left === '0px') {
    sidebar.style.left = '-260px'; // সাইডবার বন্ধ
  } else {
    sidebar.style.left = '0px'; // সাইডবার ওপেন
  }
}

// থ্রি লাইনে ক্লিক করলে সাইডবার খুলে যাবে
document.querySelector('.header-left i').addEventListener('click', toggleSidebar);
  
  // সাইডবার টগল
  document.getElementById('menuToggle').addEventListener('click', function () {
    document.getElementById('sidebar').classList.toggle('active');
  });
function toggleSidebar() {
  var sidebar = document.getElementById('sidebar');
  sidebar.style.left = (sidebar.style.left === '0px') ? '-260px' : '0px';
}
  

</script>

</body>
</html>