<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Login Page</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
  <style>
    * {
      box-sizing: border-box;
    }
    body {
      margin: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    .login-container {
      background: #ffffffdd;
      padding: 2.5rem 3rem;
      border-radius: 16px;
      box-shadow: 0 12px 30px rgba(0, 0, 0, 0.25);
      width: 350px;
      text-align: center;
    }
    .login-container h2 {
      margin-bottom: 2rem;
      font-weight: 700;
      color: #2c2c54;
      letter-spacing: 1.1px;
    }
    .input-group {
      position: relative;
      margin-bottom: 1.8rem;
    }
    .input-group i {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #6a11cb;
      font-size: 1.2rem;
      pointer-events: none;
    }
    input[type="text"],
    input[type="password"] {
      width: 100%;
      padding: 12px 12px 12px 42px;
      border: 2px solid #6a11cb;
      border-radius: 10px;
      font-size: 1rem;
      color: #2c2c54;
      transition: 0.3s ease;
    }
    input[type="text"]:focus,
    input[type="password"]:focus {
      outline: none;
      border-color: #2575fc;
      box-shadow: 0 0 8px #2575fcaa;
    }
    input::placeholder {
      color: #8888aa;
      font-style: italic;
    }
    .btn { 
      width: 100%;
      padding: 12px 0;
      border: none;
      border-radius: 12px;
      font-weight: 700;
      font-size: 1.1rem;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }
    .btn-login {
      background: #6a11cb;
      color: white;
      margin-bottom: 1rem;
      box-shadow: 0 8px 15px rgba(106, 17, 203, 0.4);
    }
    .btn-login:hover {
      background: #4e0fb3;
    }
    .btn-register {
      background: transparent;
      color: #6a11cb;
      border: 2px solid #6a11cb;
    }
    .btn-register:hover {
      background: #6a11cb;
      color: white;
    }
    .footer-text {
      margin-top: 0.6rem;
      font-size: 0.9rem;
      color: #444475;
    }
    .error-text {
      color: red;
      font-size: 0.85rem;
      margin-top: -1rem;
      margin-bottom: 1rem;
      text-align: left;
    }
    @media (max-width: 400px) { 
      .login-container {
        width: 90%;
        padding: 2rem 1.5rem;
      }
    }
  </style>
</head>
<body>
  <div class="login-container" role="main" aria-label="Login form">
    <h2>Login to Your Account</h2>

    <form method="POST" action="<?php echo e(route('login_submit')); ?>">
      <?php echo csrf_field(); ?>
      <div class="form-group input-group">
        <input class="form-control" type="text" name="login_phone" placeholder="Phone" value="">
        <span class="input-group-addon"><i class="fas fa-phone"></i></span>
      </div>

      <div class="form-group input-group">
        <input class="form-control" type="password" name="login_password" placeholder="Password">
        <span class="input-group-addon"><i class="fas fa-lock"></i></span>
      </div>

      <button type="submit" class="btn btn-login" aria-label="Login Button">
        <i class="fas fa-sign-in-alt"></i> Login
      </button>

      <a href="<?php echo e(route('register')); ?>" class="btn btn-register d-block text-center" aria-label="Register Button">
        <i class="fas fa-user-plus"></i> Register
      </a>
    </form>

    <p class="footer-text">New here? Register to get started!</p>
  </div>
</body>
</html>
<?php /**PATH /home/themrsho/public_html/incomespot.the-mr.shop/resources/views/user/login.blade.php ENDPATH**/ ?>