

<?php $__env->startSection('content-header'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">Leaders</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('AdminDash')); ?>">Dashboard</a></li>
                    <li class="breadcrumb-item active">Leaders</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Leaders List</h3>
                <button class="btn btn-primary float-right" data-toggle="modal" data-target="#addLeaderModal">Add New Leader</button>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User</th>
                            <th>Rank</th>
                            <th>Reffer</th>
                            <th>Salary</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $leaders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $leader): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($leader->id); ?></td>
                                <td><?php echo e($leader->user->fname ?? ''); ?> <?php echo e($leader->user->lname ?? ''); ?></td>
                                <td><?php echo e($leader->rank); ?></td>
                                <td><?php echo e($leader->reffer); ?></td>
                                <td><?php echo e($leader->salary); ?> BDT</td>
                                <td>
                                    <button class="btn btn-sm btn-warning" data-toggle="modal" data-target="#editLeaderModal_<?php echo e($leader->id); ?>">Edit</button>
                                    <form action="<?php echo e(route('AdminLeadersDelete', $leader->id)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                    </form>
                                </td>
                            </tr>

                            <!-- Edit Leader Modal -->
                            <div class="modal fade" id="editLeaderModal_<?php echo e($leader->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editLeaderModalLabel_<?php echo e($leader->id); ?>" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form method="POST" action="<?php echo e(route('AdminLeadersAdd')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="user_id" value="<?php echo e($leader->user_id); ?>">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Edit Leader</h5>
                                                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label for="rank">Rank</label>
                                                    <input type="text" name="rank" value="<?php echo e($leader->rank); ?>" class="form-control" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="reffer">Reffers</label>
                                                    <input type="number" name="reffer" value="<?php echo e($leader->reffer); ?>" class="form-control" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="salary">Salary</label>
                                                    <input type="number" name="salary" value="<?php echo e($leader->salary); ?>" class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-primary">Update Leader</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($leaders->links('pagination::bootstrap-4')); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Leader Modal -->
<div class="modal fade" id="addLeaderModal" tabindex="-1" role="dialog" aria-labelledby="addLeaderModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form method="POST" action="<?php echo e(route('AdminLeadersAdd')); ?>">
            <?php echo csrf_field(); ?>
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Leader</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="user_id">Select User</label>
                        <div class="searchable-dropdown">
                            <input type="text" id="searchInput" class="form-control" placeholder="Search for a user..." onkeyup="filterUsers()">
                            <select name="user_id" class="form-control" id="userSelect" required>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>" data-email="<?php echo e($user->email); ?>">
                                        <?php echo e($user->fname); ?> <?php echo e($user->lname); ?> (<?php echo e($user->email); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="rank">Rank</label>
                        <input type="text" name="rank" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="reffer">Reffer</label>
                        <input type="text" name="reffer" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="salary">Salary</label>
                        <input type="number" name="salary" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Add Leader</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Custom Search Function -->
<script>
    function filterUsers() {
        var input, filter, select, options, i, txtValue;
        input = document.getElementById('searchInput');
        filter = input.value.toUpperCase();
        select = document.getElementById("userSelect");
        options = select.getElementsByTagName('option');
        var uniqueOptions = new Set();

        for (i = 0; i < options.length; i++) {
            txtValue = options[i].textContent || options[i].innerText;
            // Check if the option is already added
            if (uniqueOptions.has(txtValue)) {
                options[i].style.display = "none"; // Hide duplicate option
            } else {
                uniqueOptions.add(txtValue);
                if (txtValue.toUpperCase().indexOf(filter) > -1) {
                    options[i].style.display = "";
                } else {
                    options[i].style.display = "none";
                }
            }
        }
    }
</script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/earnjobs/public_html/resources/views/dashboard/leaders.blade.php ENDPATH**/ ?>