<!DOCTYPE html>
<html lang="bn">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Baby Code Landing Page</title>
<!-- Font Awesome CDN -->
<link
  rel="stylesheet"
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
/>
<style>
  /* Reset & base */
  * {
    box-sizing: border-box;
  }
  body {
    margin: 0;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: #f3f6fd;
    color: #333;
    display: flex;
    flex-direction: column;
    min-height: 100vh;
  }
  /* Header with center title and right profile */
  header {
    background: #4a90e2;
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 15px;
    height: 60px;
    box-shadow: 0 2px 8px rgb(74 144 226 / 0.4);
  }
  .header-left {
    width: 40px; /* to keep space */
  }
  .header-center {
    font-weight: 700;
    font-size: 22px;
    letter-spacing: 1.2px;
    user-select: none;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-grow: 1;
    gap: 8px;
  }
  .header-center i {
    color: #bbe1ff;
    font-size: 24px;
  }
  .header-right i {
    font-size: 28px;
    cursor: pointer;
  }
  /* Banner */
  .banner {
    background: linear-gradient(135deg, #00c6ff 0%, #0072ff 100%);
    color: white;
    margin: 20px 15px 10px;
    border-radius: 14px;
    min-height: 160px;
    display: flex;
    align-items: center;
    justify-content: center; 
    font-size: 20px;
    font-weight: 600;
    text-align: center;
    padding: 20px;
    box-shadow: 0 10px 20px rgb(0 112 255 / 0.35);
    user-select: none;
  }
  /* Toolbox below banner with menu button and login/register */
  .toolbox {
    background: #ffffff;
    margin: 10px 15px 25px;
    padding: 12px 18px;
    border-radius: 14px;
    box-shadow: 0 4px 14px rgb(74 144 226 / 0.18);
    display: flex;
    align-items: center;
    justify-content: flex-start;
    gap: 20px;
  }
  .toolbox .menu-btn i {
    font-size: 24px;
    color: #4a90e2;
    cursor: pointer;
  }
  .toolbox .login-register {
    display: flex;
    gap: 14px;
  }
  .toolbox .login-register button {
    background: #4a90e2;
    border: none;
    padding: 8px 20px;
    border-radius: 24px;
    cursor: pointer;
    font-weight: 700;
    color: #fff;
    box-shadow: 0 4px 10px rgb(74 144 226 / 0.6);
    transition: background-color 0.3s ease, box-shadow 0.3s ease;
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 15px;
  }
  .toolbox .login-register button:hover {
    background-color: #2c61b5;
    box-shadow: 0 6px 14px rgb(44 97 181 / 0.8);
  }
  .toolbox .login-register button i {
    font-size: 18px;
  }
  /* Info Boxes Container */
  .info-boxes {
    margin: 0 15px 30px;
    display: flex;
    justify-content: space-between;
    gap: 15px;
    flex-wrap: wrap;
  }
  /* Each Box */
  .info-box {
    background: #fff;
    flex: 1 1 30%;
    padding: 18px 22px;
    border-radius: 14px;
    text-align: center;
    box-shadow: 0 4px 12px rgb(74 144 226 / 0.15);
    transition: box-shadow 0.3s ease;
    cursor: default;
  }
  .info-box:hover {
    box-shadow: 0 6px 20px rgb(74 144 226 / 0.35);
  }
  .info-box i {
    font-size: 36px;
    color: #4a90e2;
    margin-bottom: 12px;
  }
  .info-box h3 {
    margin: 8px 0 12px;
    font-weight: 700;
    font-size: 18px;
    color: #1d3c78;
  }
  .info-box p {
    font-size: 14px;
    color: #555;
    line-height: 1.4;
  }
  /* Footer */
  footer {
    text-align: center;
    color: #4a90e2;
    font-weight: 700;
    padding: 15px 10px;
    background: #e6f0ff;
    font-size: 16px;
    user-select: none;
    box-shadow: inset 0 1px 3px rgb(74 144 226 / 0.2);
    margin-top: auto;
  }
  /* Responsive */
  @media (max-width: 720px) {
    .info-boxes {
      flex-direction: column;
    }
    .info-box {
      flex: 1 1 100%;
    }
    .banner {
      font-size: 18px;
      min-height: 130px;
    }
    .toolbox {
      justify-content: center;
      gap: 15px;
      flex-wrap: wrap;
    }
    .toolbox .login-register {
      gap: 10px;
    }
    .header-center {
      font-size: 20px;
    }
  }
</style>
</head>
<body>
  <header>
    <div class="header-left" aria-hidden="true"></div>
    <div class="header-center" aria-label="Site title">
      Baby Code <i class="fas fa-baby"></i>
    </div>
    <div class="header-right" aria-label="Profile">
      <i class="fas fa-user-circle" title="Profile"></i>
    </div>
  </header>

  <section class="banner" aria-label="Banner area">
    <!-- You can replace this content with your banner -->
    Welcome to Baby Code! Your coding journey starts here.
  </section>

  <section class="toolbox" aria-label="Toolbox with menu and login/register buttons">
  <div class="menu-btn" aria-label="Menu button"></div>
  <div class="login-register" aria-label="Login and Register buttons">
    <button type="button" title="Login" onclick="location.href='/login'">
      <i class="fas fa-sign-in-alt"></i> Login
    </button>
    <button type="button" title="Register" onclick="location.href='/register'">
      <i class="fas fa-user-plus"></i> Register
    </button>
  </div>
</section>

  <section class="info-boxes" aria-label="Information boxes">
    <article class="info-box" aria-labelledby="helpline-title">
      <i class="fas fa-phone-volume"></i>
      <h3 id="helpline-title">হেল্প লাইন</h3>
      <p>আপনার যেকোনো সমস্যার জন্য আমাদের হেল্পলাইন নম্বরে যোগাযোগ করুন। ২৪/৭ সহায়তা প্রদান করা হয়।</p>
    </article>
    <article class="info-box" aria-labelledby="income-title">
      <i class="fas fa-dollar-sign"></i>
      <h3 id="income-title">ইনকাম সমূহ</h3>
      <p>আপনার কোডিং দক্ষতার মাধ্যমে আয় করতে পারবেন বিভিন্ন প্রোগ্রাম ও প্রকল্প থেকে।</p>
    </article>
    <article class="info-box" aria-labelledby="refer-income-title">
      <i class="fas fa-hand-holding-usd"></i>
      <h3 id="refer-income-title">রেফার ইনকাম</h3>
      <p>বন্ধু ও পরিবারের সদস্যদের রেফার করে অতিরিক্ত আয় বাড়ান খুব সহজেই।</p>
    </article>
  </section>

  <footer>
    baby@code
  </footer>
</body>
</html>


<?php /**PATH /home/themrsho/public_html/incomespot.the-mr.shop/resources/views/user/index.blade.php ENDPATH**/ ?>